/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.module.csv;

import java.util.Optional;
import java.util.stream.Stream;
import org.wso2.carbon.module.core.SimpleMediator;
import org.wso2.carbon.module.core.SimpleMessageContext;
import org.wso2.carbon.module.core.models.CsvPayloadInfo;
import org.wso2.carbon.module.csv.constant.HeaderAvailability;
import org.wso2.carbon.module.csv.constant.OrderingType;
import org.wso2.carbon.module.csv.util.CsvTransformer;
import org.wso2.carbon.module.csv.util.PropertyReader;

public class CsvToCsvTransformer
extends SimpleMediator {
    public void mediate(SimpleMessageContext mc) {
        HeaderAvailability headerAvailability = PropertyReader.getEnumParam(mc, "headerPresent", HeaderAvailability.class, HeaderAvailability.ABSENT);
        Optional<Character> valueSeparatorOptional = PropertyReader.getCharParam(mc, "valueSeparator");
        char valueSeparator = valueSeparatorOptional.orElse(Character.valueOf(',')).charValue();
        boolean skipHeader = PropertyReader.getBooleanParam(mc, "skipHeader");
        Optional<Integer> dataRowsToSkip = PropertyReader.getIntegerParam(mc, "dataRowsToSkip");
        Optional<String> columnsToSkipQuery = PropertyReader.getStringParam(mc, "columnsToSkip");
        Optional<String> orderByColumnQuery = PropertyReader.getStringParam(mc, "orderByColumn");
        OrderingType columnOrdering = PropertyReader.getEnumParam(mc, "columnOrdering", OrderingType.class, OrderingType.ASCENDING);
        Optional<String> customHeader = PropertyReader.getStringParam(mc, "customHeader");
        Optional<Character> customValueSeparator = PropertyReader.getCharParam(mc, "customValueSeparator");
        boolean suppressEscapeCharacters = PropertyReader.getBooleanParam(mc, "suppressEscaping");
        CsvPayloadInfo payloadInfo = new CsvPayloadInfo();
        if (headerAvailability == HeaderAvailability.PRESENT || customHeader.isPresent()) {
            payloadInfo = mc.getCsvPayloadInfo(valueSeparator);
        }
        String[] header = CsvTransformer.getHeader(payloadInfo, headerAvailability);
        int linesToSkip = CsvTransformer.getLinesToSkip(headerAvailability, dataRowsToSkip.orElse(0));
        Stream<String[]> csvArrayStream = mc.getCsvArrayStream(linesToSkip, valueSeparator);
        if (orderByColumnQuery.isPresent()) {
            csvArrayStream = this.reorder(CsvTransformer.resolveColumnIndex(orderByColumnQuery.get(), header), csvArrayStream, columnOrdering);
        }
        if (columnsToSkipQuery.isPresent()) {
            csvArrayStream = CsvTransformer.skipColumns(payloadInfo.getNumberOfColumns(), columnsToSkipQuery.get(), csvArrayStream, header);
        }
        String[] resultHeader = null;
        if (headerAvailability == HeaderAvailability.PRESENT) {
            if (customHeader.isPresent()) {
                resultHeader = this.getCustomHeader(customHeader.get());
            } else if (!skipHeader) {
                resultHeader = header;
            }
        } else if (customHeader.isPresent()) {
            resultHeader = this.getCustomHeader(customHeader.get());
        }
        if (columnsToSkipQuery.isPresent() && resultHeader != null && !customHeader.isPresent()) {
            resultHeader = CsvTransformer.skipColumnsSingleRow(payloadInfo.getNumberOfColumns(), columnsToSkipQuery.get(), payloadInfo.getFirstRow(), resultHeader);
        }
        csvArrayStream.collect(mc.collectToCsv(resultHeader, customValueSeparator.orElse(Character.valueOf(',')).charValue(), suppressEscapeCharacters));
    }

    private String[] getCustomHeader(String customHeader) {
        return customHeader.split(",");
    }

    private Stream<String[]> reorder(int orderByColumn, Stream<String[]> csvArrayStream, OrderingType orderingType) {
        if (orderByColumn >= 0) {
            csvArrayStream = csvArrayStream.sorted((row1, row2) -> {
                String val1 = this.getCellValue((String[])row1, orderByColumn);
                String val2 = this.getCellValue((String[])row2, orderByColumn);
                int comparisonResult = val1.compareTo(val2);
                if (orderingType == OrderingType.DESCENDING) {
                    comparisonResult = -comparisonResult;
                }
                return comparisonResult;
            });
        }
        return csvArrayStream;
    }

    private String getCellValue(String[] row, int index) {
        int rowLength = row.length;
        if (index >= rowLength) {
            return "";
        }
        return row[index];
    }
}

