/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.module.csv;

import java.util.Optional;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.module.core.SimpleMessageContext;
import org.wso2.carbon.module.csv.AbstractCsvToAnyTransformer;
import org.wso2.carbon.module.csv.util.PropertyReader;

public class CsvToXmlTransformer
extends AbstractCsvToAnyTransformer {
    @Override
    void mediate(SimpleMessageContext mc, Stream<String[]> csvArrayStream, String[] header) {
        Optional<String> tagNamesQuery = PropertyReader.getStringParam(mc, "tagNames");
        Optional<String> rootElementTagNameQuery = PropertyReader.getStringParam(mc, "rootElementTag");
        String rootElementTagName = rootElementTagNameQuery.orElse("root");
        Optional<String> rootElementNamespaceQuery = PropertyReader.getStringParam(mc, "rootElementNamespace");
        Optional<String> rootElementNamespaceUriQuery = PropertyReader.getStringParam(mc, "rootElementNamespaceURI");
        Optional<String> groupElementTagNameQuery = PropertyReader.getStringParam(mc, "groupElementTag");
        String groupElementTagName = groupElementTagNameQuery.orElse("group");
        Optional<String> groupElementNamespaceQuery = PropertyReader.getStringParam(mc, "groupElementNamespace");
        Optional<String> groupElementNamespaceUriQuery = PropertyReader.getStringParam(mc, "groupElementNamespaceURI");
        String[] tagNames = this.generateObjectKeys(tagNamesQuery.orElse(""), header);
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement rootElement = !rootElementNamespaceUriQuery.isPresent() ? fac.createOMElement(new QName(rootElementTagName)) : (!rootElementNamespaceQuery.isPresent() ? fac.createOMElement(new QName(rootElementNamespaceUriQuery.get(), rootElementTagName)) : fac.createOMElement(new QName(rootElementNamespaceUriQuery.get(), rootElementTagName, rootElementNamespaceQuery.get())));
        OMElement groupElement = !groupElementNamespaceUriQuery.isPresent() ? fac.createOMElement(new QName(groupElementTagName)) : (!groupElementNamespaceQuery.isPresent() ? fac.createOMElement(new QName(groupElementNamespaceUriQuery.get(), groupElementTagName)) : fac.createOMElement(new QName(groupElementNamespaceUriQuery.get(), groupElementTagName, groupElementNamespaceQuery.get())));
        csvArrayStream.forEach(row -> {
            OMElement childElement = groupElement.cloneOMElement();
            for (int i = 0; i < ((String[])row).length; ++i) {
                String tagName = this.getObjectKey(tagNames, i);
                OMElement valueElement = fac.createOMElement(new QName(tagName));
                valueElement.setText(row[i]);
                childElement.addChild((OMNode)valueElement);
            }
            rootElement.addChild((OMNode)childElement);
        });
        mc.replaceRootXmlElement(rootElement);
    }
}

