/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.module.csv;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.module.core.SimpleMediator;
import org.wso2.carbon.module.core.SimpleMessageContext;
import org.wso2.carbon.module.csv.util.PropertyReader;

public class JsonToCsvTransformer
extends SimpleMediator {
    public void mediate(SimpleMessageContext mc) {
        boolean suppressEscapeCharacters = PropertyReader.getBooleanParam(mc, "suppressEscaping");
        String[] header = this.getHeader(mc);
        mc.getJsonArrayStream().map(JsonElement::getAsJsonObject).map(obj -> {
            ArrayList<String> csvEntry = new ArrayList<String>();
            Set entries = obj.entrySet();
            for (Map.Entry elementEntry : entries) {
                if (elementEntry.getValue() instanceof JsonNull) {
                    csvEntry.add("");
                    continue;
                }
                csvEntry.add(((JsonElement)elementEntry.getValue()).getAsString());
            }
            return csvEntry.toArray(new String[0]);
        }).collect(mc.collectToCsv(header, suppressEscapeCharacters));
    }

    private String[] getHeader(SimpleMessageContext mc) {
        String[] header = null;
        String headerToAppend = (String)mc.lookupTemplateParameter("customHeader");
        if (!StringUtils.isBlank((String)headerToAppend)) {
            header = headerToAppend.split(",");
        } else {
            JsonElement firstElement;
            JsonArray jsonArray;
            JsonElement jsonPayload = mc.getJsonElement();
            if (jsonPayload.isJsonArray() && (jsonArray = jsonPayload.getAsJsonArray()).size() > 0 && (firstElement = jsonArray.get(0)).isJsonObject()) {
                JsonObject firstJsonObject = firstElement.getAsJsonObject();
                return firstJsonObject.keySet().toArray(new String[0]);
            }
        }
        return header;
    }
}

