/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.module.csv.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.module.core.exceptions.SimpleMessageContextException;
import org.wso2.carbon.module.core.models.CsvPayloadInfo;
import org.wso2.carbon.module.csv.constant.HeaderAvailability;
import org.wso2.carbon.module.csv.util.parser.Parser;
import org.wso2.carbon.module.csv.util.parser.Tokenizer;
import org.wso2.carbon.module.csv.util.parser.model.Token;

public class CsvTransformer {
    private static final Log log = LogFactory.getLog(CsvTransformer.class);
    private static final Pattern doubleQuotedTextPattern = Pattern.compile("\"([^\"]+)\"");

    private CsvTransformer() {
    }

    public static String[] getHeader(CsvPayloadInfo payloadInfo, HeaderAvailability headerAvailability) {
        String[] header = new String[]{};
        if (headerAvailability == HeaderAvailability.PRESENT) {
            if (payloadInfo.getNumberOfColumns() > 0) {
                header = payloadInfo.getFirstRow();
            } else {
                throw new SimpleMessageContextException("Invalid csv content");
            }
        }
        return header;
    }

    public static int getLinesToSkip(HeaderAvailability headerAvailability, int dataRowsToSkip) {
        int linesToSkip = dataRowsToSkip;
        if (headerAvailability == HeaderAvailability.PRESENT) {
            ++linesToSkip;
        }
        return linesToSkip;
    }

    public static Stream<String[]> skipColumns(int columnCount, String skipColumnsQuery, Stream<String[]> csvArrayStream, String[] header) {
        Optional<int[]> skippingColumns = CsvTransformer.getSkippingColumns(columnCount, skipColumnsQuery, header);
        if (skippingColumns.isPresent()) {
            csvArrayStream = csvArrayStream.map(Arrays::asList).map(LinkedList::new).map(row -> CsvTransformer.skipColumns((int[])skippingColumns.get(), row));
        }
        return csvArrayStream;
    }

    private static String[] skipColumns(int[] skippingColumns, List<String> row) {
        int[] currentSkippingColumns = (int[])skippingColumns.clone();
        for (int i = 0; i < currentSkippingColumns.length; ++i) {
            int j = i;
            while (j < currentSkippingColumns.length) {
                int n = j++;
                currentSkippingColumns[n] = currentSkippingColumns[n] - 1;
            }
            int currentIndex = currentSkippingColumns[i];
            if (currentIndex >= 0 && currentIndex < row.size()) {
                row.remove(currentIndex);
                continue;
            }
            log.debug((Object)"Invalid index to remove");
        }
        return row.toArray(new String[0]);
    }

    public static String[] skipColumnsSingleRow(int columnCount, String columnsToSkip, String[] row, String[] header) {
        Optional<int[]> skippingColumns = CsvTransformer.getSkippingColumns(columnCount, columnsToSkip, header);
        return skippingColumns.map(ints -> CsvTransformer.skipColumns(ints, new ArrayList<String>(Arrays.asList(row)))).orElse(row);
    }

    private static Optional<int[]> getSkippingColumns(int columnCount, String skipColumnsQuery, String[] header) {
        Optional<Object> skippingColumns;
        if (StringUtils.isNotBlank((String)skipColumnsQuery)) {
            try {
                skippingColumns = Optional.of(CsvTransformer.parseColumnExpression(skipColumnsQuery, columnCount, header));
            }
            catch (Exception e) {
                log.debug((Object)"Invalid Skipping Columns query (no columns would be skipped)", (Throwable)e);
                skippingColumns = Optional.empty();
            }
        } else {
            skippingColumns = Optional.empty();
        }
        return skippingColumns;
    }

    private static int[] parseColumnExpression(String skippingColumnsQuery, int columnCount, String[] header) {
        skippingColumnsQuery = CsvTransformer.preProcessExpression(skippingColumnsQuery, header);
        Tokenizer tokenizer = new Tokenizer();
        Parser parser = new Parser();
        tokenizer.tokenize(skippingColumnsQuery);
        LinkedList<Token> tokens = new LinkedList<Token>(tokenizer.getTokens());
        return parser.parseAndGetValues(tokens, columnCount).stream().mapToInt(Integer::intValue).toArray();
    }

    private static String preProcessExpression(String query, String[] header) {
        String queryClone = query;
        Matcher matcher = doubleQuotedTextPattern.matcher(query);
        while (matcher.find()) {
            String match = matcher.group();
            int matchingColumnIndex = CsvTransformer.getMatchingColumnIndex(header, match);
            if (matchingColumnIndex < 0) {
                log.error((Object)("Invalid column skipping query (no columns would be skipped) : " + query));
                return queryClone;
            }
            query = query.replaceFirst(match, String.valueOf(++matchingColumnIndex));
        }
        return query;
    }

    public static int resolveColumnIndex(String query, String[] header) {
        Matcher matcher;
        int columnIndex = -1;
        columnIndex = header.length == 0 ? CsvTransformer.extractColumnIndex(query) - 1 : ((matcher = doubleQuotedTextPattern.matcher(query)).find() ? CsvTransformer.getMatchingColumnIndex(header, matcher.group()) : CsvTransformer.extractColumnIndex(query) - 1);
        return columnIndex;
    }

    private static int getMatchingColumnIndex(String[] header, String match) {
        int columnIndex = -1;
        String columnName = match.replaceAll("\"", "");
        if (header != null) {
            for (int i = 0; i < header.length; ++i) {
                if (!header[i].equalsIgnoreCase(columnName)) continue;
                columnIndex = i;
                break;
            }
        }
        return columnIndex;
    }

    private static int extractColumnIndex(String intQuery) {
        try {
            return Integer.parseInt(intQuery);
        }
        catch (NumberFormatException e) {
            log.error((Object)("Invalid query to select columns: " + intQuery));
            return -1;
        }
    }
}

