/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.module.csv.util.parser;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.wso2.carbon.module.csv.util.parser.exception.ParserException;
import org.wso2.carbon.module.csv.util.parser.expressionnode.ComaExpressionNode;
import org.wso2.carbon.module.csv.util.parser.expressionnode.ConstantExpressionNode;
import org.wso2.carbon.module.csv.util.parser.expressionnode.ExpressionNode;
import org.wso2.carbon.module.csv.util.parser.expressionnode.NegationExpressionNode;
import org.wso2.carbon.module.csv.util.parser.expressionnode.RangeExpressionNode;
import org.wso2.carbon.module.csv.util.parser.expressionnode.WildcardRangeExpression;
import org.wso2.carbon.module.csv.util.parser.model.Token;

public class Parser {
    private LinkedList<Token> tokens;
    private Token lookahead;
    private int maxValue;

    public List<Integer> parseAndGetValues(List<Token> tokens, int maxValue) {
        ExpressionNode expressionNode = this.parse(tokens, maxValue);
        List<Integer> values = expressionNode.getValue();
        int size = values.size();
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            int val = values.get(i);
            if (val <= 0) continue;
            boolean isValid = true;
            for (int j = i + 1; j < size; ++j) {
                if (val != -values.get(j).intValue()) continue;
                isValid = false;
                break;
            }
            if (!isValid) continue;
            result.add(val);
        }
        return result.stream().sorted().distinct().collect(Collectors.toList());
    }

    private ExpressionNode parse(List<Token> tokens, int maxValue) {
        this.tokens = new LinkedList<Token>(tokens);
        this.maxValue = maxValue;
        this.lookahead = this.tokens.getFirst();
        ExpressionNode expression = this.expression();
        if (this.lookahead.tokenType != 0) {
            throw new ParserException(this.lookahead.sequence);
        }
        return expression;
    }

    private ExpressionNode expression() {
        ExpressionNode operation = this.lookahead.tokenType == 4 ? this.value() : (this.lookahead.tokenType == 6 ? this.negation() : this.statement());
        return this.rangeOrExpression(operation);
    }

    private ExpressionNode value() {
        if (this.lookahead.tokenType == 4) {
            ConstantExpressionNode constantExpressionNode = new ConstantExpressionNode(this.lookahead.sequence);
            this.nextToken();
            return constantExpressionNode;
        }
        throw new ParserException(this.lookahead.sequence);
    }

    private ExpressionNode negation() {
        this.nextToken();
        ExpressionNode value = this.lookahead.tokenType == 4 ? this.value() : this.statement();
        return new NegationExpressionNode(value);
    }

    private ExpressionNode statement() {
        if (this.lookahead.tokenType == 1) {
            this.nextToken();
            ExpressionNode value = this.value();
            ExpressionNode resultNode = this.rangeOrExpression(value);
            if (this.lookahead.tokenType != 2) {
                throw new ParserException("need closing bracket");
            }
            this.nextToken();
            return resultNode;
        }
        throw new ParserException(this.lookahead.sequence);
    }

    private ExpressionNode rangeOrExpression(ExpressionNode value) {
        ExpressionNode resultNode;
        if (this.lookahead.tokenType == 5) {
            this.nextToken();
            resultNode = this.range(value);
        } else {
            resultNode = this.expressionNotRange(value);
        }
        return resultNode;
    }

    private ExpressionNode expressionNotRange(ExpressionNode value) {
        if (this.lookahead.tokenType != 3) {
            if (this.lookahead.tokenType == 0 || this.lookahead.tokenType == 2) {
                return value;
            }
            throw new ParserException(this.lookahead.sequence);
        }
        this.nextToken();
        ExpressionNode expressionNode = this.expression();
        ComaExpressionNode resultNode = new ComaExpressionNode(value, expressionNode);
        return resultNode;
    }

    private ExpressionNode range(ExpressionNode firstValue) {
        ExpressionNode rangeExpression;
        if (this.lookahead.tokenType == 4) {
            ExpressionNode secondValue = this.value();
            rangeExpression = new RangeExpressionNode(firstValue, secondValue);
        } else if (this.lookahead.tokenType == 7) {
            this.nextToken();
            rangeExpression = new WildcardRangeExpression(firstValue, this.maxValue);
        } else {
            throw new ParserException("Expected a number after colon, but found : " + this.lookahead.sequence);
        }
        return this.expressionNotRange(rangeExpression);
    }

    private void nextToken() {
        this.tokens.pop();
        this.lookahead = this.tokens.isEmpty() ? new Token(0, "") : this.tokens.getFirst();
    }
}

