/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.module.csv.util.parser;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wso2.carbon.module.csv.util.parser.exception.ParserException;
import org.wso2.carbon.module.csv.util.parser.model.Token;
import org.wso2.carbon.module.csv.util.parser.model.TokenInfo;

public class Tokenizer {
    private final LinkedList<TokenInfo> tokenInfos = new LinkedList();
    private final LinkedList<Token> tokens = new LinkedList();

    public Tokenizer() {
        this.initTokens();
    }

    private void initTokens() {
        this.addTokenInfo("\\(", 1);
        this.addTokenInfo("\\)", 2);
        this.addTokenInfo("\\,", 3);
        this.addTokenInfo("\\d+", 4);
        this.addTokenInfo("\\:", 5);
        this.addTokenInfo("\\!", 6);
        this.addTokenInfo("\\*", 7);
    }

    public void addTokenInfo(String regex, int token) {
        this.tokenInfos.add(new TokenInfo(Pattern.compile("^(" + regex + ")"), token));
    }

    public void tokenize(String str) {
        String s = str.trim();
        this.tokens.clear();
        while (!s.equals("")) {
            boolean match = false;
            for (TokenInfo info : this.tokenInfos) {
                Matcher m = info.regex.matcher(s);
                if (!m.find()) continue;
                match = true;
                String tok = m.group().trim();
                this.tokens.add(new Token(info.token, tok));
                s = m.replaceFirst("");
                break;
            }
            if (match) continue;
            throw new ParserException(s);
        }
    }

    public List<Token> getTokens() {
        return this.tokens;
    }
}

