/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.esb.connector.date;

import java.util.Optional;
import org.apache.synapse.MessageContext;
import org.wso2.carbon.connector.core.AbstractConnector;
import org.wso2.carbon.connector.core.ConnectException;
import org.wso2.carbon.esb.connector.date.utils.Date;
import org.wso2.carbon.esb.connector.date.utils.exception.IllegalDateFormatException;
import org.wso2.carbon.esb.connector.utils.PropertyReader;

public class GetDate
extends AbstractConnector {
    public void connect(MessageContext messageContext) throws ConnectException {
        Optional<String> dateFormatOptional = PropertyReader.getStringProperty(messageContext, "format");
        Optional<String> saveToPropertyOptional = PropertyReader.getStringProperty(messageContext, "target");
        String dateFormat = dateFormatOptional.orElse("yyyy-MM-dd HH:mm:ss");
        String saveToProperty = saveToPropertyOptional.orElse("date");
        try {
            String date = Date.getDate(dateFormat);
            messageContext.setProperty(saveToProperty, (Object)date);
        }
        catch (IllegalDateFormatException exception) {
            this.log.error((Object)"Invalid date format", exception.getCause());
        }
    }
}

