/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.esb.connector.hmac;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import org.apache.synapse.MessageContext;
import org.wso2.carbon.connector.core.AbstractConnector;
import org.wso2.carbon.connector.core.ConnectException;
import org.wso2.carbon.esb.connector.hmac.utils.HMACUtils;
import org.wso2.carbon.esb.connector.hmac.utils.HMACVerify;
import org.wso2.carbon.esb.connector.hmac.utils.constants.HMACAlgorithm;
import org.wso2.carbon.esb.connector.hmac.utils.exception.InvalidSecretException;
import org.wso2.carbon.esb.connector.utils.PropertyReader;
import org.wso2.carbon.esb.connector.utils.exception.InvalidParameterValueException;
import org.wso2.carbon.esb.connector.utils.exception.NoSuchContentTypeException;
import org.wso2.carbon.esb.connector.utils.exception.PayloadNotFoundException;

public class Verify
extends AbstractConnector {
    public void connect(MessageContext messageContext) throws ConnectException {
        Optional<String> payloadFromOptional = PropertyReader.getStringProperty(messageContext, "payload");
        Optional<String> customPayloadOptional = PropertyReader.getStringProperty(messageContext, "customPayload");
        Optional<String> customSignatureOptional = PropertyReader.getStringProperty(messageContext, "signature");
        Optional<String> secretOptional = PropertyReader.getStringProperty(messageContext, "secret");
        Optional<String> saveToPropertyOptional = PropertyReader.getStringProperty(messageContext, "target");
        String payload = null;
        try {
            payload = HMACUtils.getPayload(messageContext, payloadFromOptional, customPayloadOptional);
            String customSignature = customSignatureOptional.orElse("");
            String secret = secretOptional.orElse("");
            String saveToProperty = saveToPropertyOptional.orElse("verify");
            HMACAlgorithm algorithm = PropertyReader.getEnumProperty(messageContext, "algorithm", HMACAlgorithm.class, HMACAlgorithm.HMACSHA1);
            boolean verifyResult = HMACVerify.verify(payload, secret, algorithm.toString(), customSignature);
            messageContext.setProperty(saveToProperty, (Object)verifyResult);
        }
        catch (NoSuchContentTypeException e) {
            this.log.error((Object)"Invalid Content-Type: ", (Throwable)e);
        }
        catch (PayloadNotFoundException e) {
            this.log.error((Object)"No content in the message body", (Throwable)e);
        }
        catch (InvalidParameterValueException e) {
            this.log.error((Object)e.getMessage(), e.getCause());
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error((Object)"Invalid Algorithm: ", (Throwable)e);
        }
        catch (InvalidKeyException | InvalidSecretException e) {
            this.log.error((Object)"Invalid secret provided", (Throwable)e);
        }
    }
}

