/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.esb.connector.hmac.utils;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.esb.connector.hmac.utils.exception.InvalidSecretException;

public class HMACGenerator {
    private static final Map<String, Mac> macInstancesMap = new ConcurrentHashMap<String, Mac>();

    private HMACGenerator() {
    }

    public static String generateSignature(String payload, String secret, String algorithm) throws InvalidSecretException, NoSuchAlgorithmException, InvalidKeyException {
        try {
            Mac mac = HMACGenerator.getMacInstance(algorithm);
            if (StringUtils.isBlank((String)secret) || StringUtils.isEmpty((String)secret)) {
                throw new InvalidSecretException();
            }
            SecretKeySpec signingKey = new SecretKeySpec(secret.getBytes(), algorithm);
            mac.init(signingKey);
            return HMACGenerator.toHexString(mac.doFinal(payload.getBytes()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException(e);
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeyException(e);
        }
        catch (InvalidSecretException e) {
            throw new InvalidSecretException(e);
        }
    }

    private static String toHexString(byte[] bytes) {
        Formatter formatter = new Formatter();
        for (byte b : bytes) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }

    private static Mac getMacInstance(String algorithm) throws NoSuchAlgorithmException {
        Mac macInstance = macInstancesMap.get(algorithm);
        if (macInstance == null) {
            macInstance = Mac.getInstance(algorithm);
            macInstancesMap.put(algorithm, macInstance);
        }
        return macInstance;
    }
}

