/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.esb.connector.math;

import java.util.Optional;
import org.apache.synapse.MessageContext;
import org.wso2.carbon.connector.core.AbstractConnector;
import org.wso2.carbon.connector.core.ConnectException;
import org.wso2.carbon.esb.connector.math.utils.RandomNumberGenerator;
import org.wso2.carbon.esb.connector.math.utils.exception.InvalidBoundException;
import org.wso2.carbon.esb.connector.utils.PropertyReader;

public class GetRandomNumber
extends AbstractConnector {
    public void connect(MessageContext messageContext) throws ConnectException {
        Optional<Integer> originOptional = PropertyReader.getIntProperty(messageContext, "lowerBound");
        Optional<Integer> boundOptional = PropertyReader.getIntProperty(messageContext, "upperBound");
        Optional<String> saveToPropertyOptional = PropertyReader.getStringProperty(messageContext, "target");
        String saveTo = saveToPropertyOptional.orElse("random");
        int origin = originOptional.orElse(0);
        int bound = boundOptional.orElse(Integer.MAX_VALUE);
        try {
            int randomNumber = RandomNumberGenerator.generateRandomInteger(origin, bound);
            messageContext.setProperty(saveTo, (Object)randomNumber);
        }
        catch (InvalidBoundException e) {
            this.log.error((Object)"Invalid bound provided.", e.getCause());
        }
    }
}

