/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.esb.connector.string;

import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.synapse.MessageContext;
import org.wso2.carbon.connector.core.AbstractConnector;
import org.wso2.carbon.connector.core.ConnectException;
import org.wso2.carbon.esb.connector.utils.PropertyReader;

public class RegexMatcher
extends AbstractConnector {
    public void connect(MessageContext messageContext) throws ConnectException {
        Optional<String> inputOptional = PropertyReader.getStringProperty(messageContext, "inputString");
        Optional<String> regexOptional = PropertyReader.getStringProperty(messageContext, "regex");
        Optional<String> saveToPropertyOptional = PropertyReader.getStringProperty(messageContext, "target");
        String input = inputOptional.orElse("");
        String regex = regexOptional.orElse("");
        String saveToProperty = saveToPropertyOptional.orElse("match");
        try {
            Boolean matching = this.matches(regex, input);
            messageContext.setProperty(saveToProperty, (Object)matching.toString());
        }
        catch (PatternSyntaxException e) {
            this.log.error((Object)"Invalid regular expression:", (Throwable)e);
        }
    }

    private Boolean matches(String regex, String input) {
        return Pattern.matches(regex, input);
    }
}

