/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.esb.connector.utils;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.util.PayloadHelper;
import org.wso2.carbon.esb.connector.utils.exception.NoSuchContentTypeException;
import org.wso2.carbon.esb.connector.utils.exception.PayloadNotFoundException;

public class PayloadReader {
    private static final String payloadTypePropertyName = "messageType";

    public static String getPayload(org.apache.synapse.MessageContext messageContext) throws NoSuchContentTypeException, PayloadNotFoundException {
        String payloadType;
        MessageContext axis2mc = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        switch (payloadType = (String)axis2mc.getProperty(payloadTypePropertyName)) {
            case "application/json": {
                return PayloadReader.getJSONPayload(messageContext);
            }
            case "application/xml": {
                return PayloadReader.getXMLPayload(messageContext);
            }
            case "text/plain": {
                return PayloadReader.getTextPayload(messageContext);
            }
        }
        throw new NoSuchContentTypeException("The content type " + payloadType + " is not defined.");
    }

    public static String getTextPayload(org.apache.synapse.MessageContext messageContext) throws PayloadNotFoundException {
        if (messageContext.getEnvelope().getBody() == null || messageContext.getEnvelope().getBody().getFirstElement() == null) {
            throw new PayloadNotFoundException();
        }
        String payload = messageContext.getEnvelope().getBody().getFirstElement().getText();
        if (payload == null) {
            throw new PayloadNotFoundException();
        }
        return payload;
    }

    public static String getXMLPayload(org.apache.synapse.MessageContext messageContext) throws PayloadNotFoundException {
        if (messageContext.getEnvelope().getBody() == null) {
            throw new PayloadNotFoundException();
        }
        if (messageContext.getEnvelope().getBody().getFirstElement() == null) {
            return "";
        }
        OMElement el = PayloadHelper.getXMLPayload((SOAPEnvelope)messageContext.getEnvelope());
        return el.toString();
    }

    public static String getJSONPayload(org.apache.synapse.MessageContext messageContext) {
        return JsonUtil.jsonPayloadToString((MessageContext)((Axis2MessageContext)messageContext).getAxis2MessageContext());
    }
}

