/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.esb.connector.utils;

import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.synapse.MessageContext;
import org.wso2.carbon.connector.core.util.ConnectorUtils;
import org.wso2.carbon.esb.connector.utils.exception.InvalidParameterValueException;

public class PropertyReader {
    private PropertyReader() {
    }

    public static Optional<String> getStringProperty(MessageContext mc, String parameterKey) {
        String parameter = (String)ConnectorUtils.lookupTemplateParamater((MessageContext)mc, (String)parameterKey);
        if (StringUtils.isNotBlank((String)parameter)) {
            return Optional.of(parameter);
        }
        return Optional.empty();
    }

    public static Optional<Integer> getIntProperty(MessageContext mc, String parameterKey) {
        Optional<String> parameter = PropertyReader.getStringProperty(mc, parameterKey);
        return parameter.map(s -> {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return null;
            }
        });
    }

    public static <E extends Enum<E>> E getEnumProperty(MessageContext mc, String parameterKey, Class<E> enumType, E defaultValue) throws InvalidParameterValueException {
        Optional<String> property = PropertyReader.getStringProperty(mc, parameterKey);
        if (property.isPresent()) {
            try {
                return Enum.valueOf(enumType, property.get());
            }
            catch (IllegalArgumentException | NullPointerException e) {
                throw new InvalidParameterValueException(String.format("Invalid Parameter Value %s=%s", parameterKey, property.get()), e);
            }
        }
        return defaultValue;
    }
}

