/*
 * Copyright (c) 2016, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.wso2.carbon.sp.mgt.workflow.impl;

import org.wso2.carbon.identity.application.mgt.listener.AbstractApplicationMgtListener;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;

public class SPWorkflowListener extends AbstractApplicationMgtListener {

        @Override
        public int getDefaultOrderId() {
                return 1;
        }

        @Override
        public boolean doPreCreateApplication(ServiceProvider serviceProvider, String tenantDomain, String userName)
                throws IdentityApplicationManagementException {
                if (!isEnable()) {
                        return true;
                }
                try {
                        SPCreateHandler spCreateHandler = new SPCreateHandler();
                        return spCreateHandler.startSPCreateWorkflow(serviceProvider, tenantDomain, userName);
                } catch (Exception e) {
                        // Sending e.getMessage() since it is required to give error message to end user.
                        throw new IdentityApplicationManagementException(e.getMessage(), e);
                } finally {
                }
        }

}
