/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.scim.sample.group;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.wso2.charon.core.client.SCIMClient;
import org.wso2.charon.core.exceptions.CharonException;
import org.wso2.charon.core.objects.Group;
import org.wso2.charon.core.objects.ListedResource;
import org.wso2.charon.core.objects.SCIMObject;
import org.wso2.charon.core.schema.SCIMConstants;
import org.wso2.scim.sample.utils.SCIMSamplesUtils;

public class DeleteGroup {
    public static void main(String[] args) {
        try {
            SCIMSamplesUtils.loadConfiguration();
            SCIMSamplesUtils.setKeyStore();
            String groupId = DeleteGroup.getSCIMIdOfGroup(SCIMSamplesUtils.groupDisplayNameToDeleteGroup);
            String url = SCIMSamplesUtils.groupEndpointURL + "/" + groupId;
            DeleteMethod deleteMethod = new DeleteMethod(url);
            String authHeader = SCIMSamplesUtils.getAuthorizationHeader();
            deleteMethod.addRequestHeader("Authorization", authHeader);
            HttpClient httpDeleteClient = new HttpClient();
            int deleteResponseStatus = httpDeleteClient.executeMethod((HttpMethod)deleteMethod);
            String deleteResponse = deleteMethod.getResponseBodyAsString();
            System.out.println("");
            System.out.println("");
            System.out.println("/******SCIM group delete response status: " + deleteResponseStatus);
            System.out.println("SCIM group delete response data: " + deleteResponse + "******/");
            System.out.println("");
        }
        catch (CharonException e) {
            e.printStackTrace();
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getSCIMIdOfGroup(String groupName) throws Exception {
        String groupId = null;
        try {
            HttpClient httpFilterUserClient = new HttpClient();
            GetMethod getMethod = new GetMethod(SCIMSamplesUtils.groupEndpointURL);
            String authHeader = SCIMSamplesUtils.getAuthorizationHeader();
            getMethod.addRequestHeader("Authorization", authHeader);
            String filter = "filter=displayNameEq" + groupName;
            getMethod.setQueryString(filter);
            int responseCode = httpFilterUserClient.executeMethod((HttpMethod)getMethod);
            String response = getMethod.getResponseBodyAsString();
            SCIMClient scimClient = new SCIMClient();
            if (scimClient.evaluateResponseStatus(responseCode)) {
                ListedResource listedUserResource = scimClient.decodeSCIMResponseWithListedResource(response, SCIMConstants.identifyFormat((String)"application/json"), 2);
                List filteredGroups = listedUserResource.getScimObjects();
                for (SCIMObject filteredGroup : filteredGroups) {
                    groupId = ((Group)filteredGroup).getId();
                }
            }
        }
        catch (IOException e) {
            throw new Exception("Error in obtaining the SCIM Id for group: " + groupName);
        }
        catch (CharonException e) {
            throw new Exception("Error in obtaining the SCIM Id for group: " + groupName);
        }
        return groupId;
    }
}

