/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2.generate.feature;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.wso2.maven.p2.generate.utils.P2Utils;

public class Bundle {
    private String groupId;
    private String artifactId;
    private String version;
    private Artifact artifact;
    private String bundleSymbolicName;
    private String bundleVersion;
    private String compatibility;
    private static final Pattern OSGI_VERSION_PATTERN = Pattern.compile("[0-9]+\\.[0-9]+\\.[0-9]+(\\.[0-9A-Za-z_-]+)?");
    private static final Pattern ONLY_NUMBERS = Pattern.compile("[0-9]+");
    public static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    public static final String BUNDLE_VERSION = "Bundle-Version";

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version == null ? "" : this.version;
    }

    public void setCompatibility(String compatibility) {
        this.compatibility = compatibility;
    }

    public String getCompatibility() {
        return this.compatibility;
    }

    protected static Bundle getBundle(String bundleDefinition, Bundle bundle) throws MojoExecutionException {
        String[] split = bundleDefinition.split(":");
        if (split.length > 1) {
            bundle.setGroupId(split[0]);
            bundle.setArtifactId(split[1]);
            String match = "equivalent";
            if (split.length > 2) {
                if (P2Utils.isMatchString(split[2])) {
                    match = split[2].toUpperCase();
                    if (split.length > 3) {
                        bundle.setVersion(split[3]);
                    }
                } else {
                    bundle.setVersion(split[2]);
                    if (split.length > 3 && P2Utils.isMatchString(split[3])) {
                        match = split[3].toUpperCase();
                    }
                }
            }
            bundle.setCompatibility(match);
            return bundle;
        }
        throw new MojoExecutionException("Insufficient artifact information provided to determine the bundle: " + bundleDefinition);
    }

    public static Bundle getBundle(String bundleDefinition) throws MojoExecutionException {
        return Bundle.getBundle(bundleDefinition, new Bundle());
    }

    public void resolveVersion(MavenProject project) throws MojoExecutionException {
        List dependencies;
        if (this.version == null) {
            dependencies = project.getDependencies();
            for (Dependency dependancy : dependencies) {
                if (!dependancy.getGroupId().equalsIgnoreCase(this.getGroupId()) || !dependancy.getArtifactId().equalsIgnoreCase(this.getArtifactId())) continue;
                this.setVersion(dependancy.getVersion());
            }
        }
        if (this.version == null && project.getDependencyManagement() != null) {
            dependencies = project.getDependencyManagement().getDependencies();
            for (Dependency dependancy : dependencies) {
                if (!dependancy.getGroupId().equalsIgnoreCase(this.getGroupId()) || !dependancy.getArtifactId().equalsIgnoreCase(this.getArtifactId())) continue;
                this.setVersion(dependancy.getVersion());
            }
        }
        if (this.version == null) {
            throw new MojoExecutionException("Could not find the version for " + this.getGroupId() + ":" + this.getArtifactId());
        }
        Properties properties = project.getProperties();
        for (Object key : properties.keySet()) {
            this.version = this.version.replaceAll(Pattern.quote("${" + key + "}"), properties.get(key).toString());
        }
    }

    public void setArtifact(Artifact artifact) throws MojoExecutionException {
        this.artifact = artifact;
        this.resolveOSGIInfo();
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public String toString() {
        if (this.getVersion() != null && !this.getVersion().equalsIgnoreCase("")) {
            return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion();
        }
        return this.getGroupId() + ":" + this.getArtifactId();
    }

    public String toOSGIString() {
        return this.getBundleSymbolicName() + ":" + this.getBundleVersion();
    }

    public static String getOSGIVersion(String version) {
        String qualifier;
        String service;
        String minor;
        String major;
        Pattern NEED_TO_FILL_ZEROS;
        Matcher m = OSGI_VERSION_PATTERN.matcher(version);
        if (m.matches()) {
            return version;
        }
        String osgiVersion = version;
        Pattern DATED_SNAPSHOT = Pattern.compile("([0-9])(\\.([0-9]))?(\\.([0-9]))?\\-([0-9]{8}\\.[0-9]{6}\\-[0-9]*)");
        m = DATED_SNAPSHOT.matcher(osgiVersion);
        if (m.matches()) {
            String major2 = m.group(1);
            String minor2 = m.group(3) != null ? m.group(3) : "0";
            String service2 = m.group(5) != null ? m.group(5) : "0";
            String qualifier2 = m.group(6).replaceAll("-", "_").replaceAll("\\.", "_");
            osgiVersion = major2 + "." + minor2 + "." + service2 + "." + qualifier2;
        }
        osgiVersion = osgiVersion.replaceFirst("-", "\\.");
        m = OSGI_VERSION_PATTERN.matcher(osgiVersion = osgiVersion.replaceAll("-", "_"));
        if (m.matches()) {
            return osgiVersion;
        }
        Pattern DOTS_IN_QUALIFIER = Pattern.compile("([0-9])(\\.[0-9])?\\.([0-9A-Za-z_-]+)\\.([0-9A-Za-z_-]+)");
        m = DOTS_IN_QUALIFIER.matcher(osgiVersion);
        if (m.matches()) {
            String s1 = m.group(1);
            String s2 = m.group(2);
            String s3 = m.group(3);
            String s4 = m.group(4);
            Matcher qualifierMatcher = ONLY_NUMBERS.matcher(s3);
            if (!qualifierMatcher.matches()) {
                osgiVersion = s1 + s2 + "." + s3 + "_" + s4;
            }
        }
        if ((m = (NEED_TO_FILL_ZEROS = Pattern.compile("([0-9])(\\.([0-9]))?(\\.([0-9A-Za-z_-]+))?")).matcher(osgiVersion)).matches()) {
            major = m.group(1);
            minor = m.group(3);
            service = null;
            qualifier = m.group(5);
            if (qualifier == null) {
                osgiVersion = Bundle.getOSGIVersion(major, minor, service, qualifier);
            } else {
                Matcher qualifierMatcher = ONLY_NUMBERS.matcher(qualifier);
                if (qualifierMatcher.matches()) {
                    if (minor == null) {
                        minor = qualifier;
                    } else {
                        service = qualifier;
                    }
                    osgiVersion = Bundle.getOSGIVersion(major, minor, service, null);
                } else {
                    osgiVersion = Bundle.getOSGIVersion(major, minor, service, qualifier);
                }
            }
        }
        if (!(m = OSGI_VERSION_PATTERN.matcher(osgiVersion)).matches()) {
            major = "0";
            minor = "0";
            service = "0";
            qualifier = osgiVersion.replaceAll("\\.", "_");
            osgiVersion = major + "." + minor + "." + service + "." + qualifier;
        }
        return osgiVersion;
    }

    private static String getOSGIVersion(String major, String minor, String service, String qualifier) {
        StringBuffer sb = new StringBuffer();
        sb.append(major != null ? major : "0");
        sb.append('.');
        sb.append(minor != null ? minor : "0");
        sb.append('.');
        sb.append(service != null ? service : "0");
        if (qualifier != null) {
            sb.append('.');
            sb.append(qualifier);
        }
        return sb.toString();
    }

    public void setBundleSymbolicName(String bundleSymbolicName) {
        this.bundleSymbolicName = bundleSymbolicName;
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public void setBundleVersion(String bundleVersion) {
        this.bundleVersion = bundleVersion;
    }

    public String getBundleVersion() {
        return this.bundleVersion;
    }

    public void resolveOSGIInfo() throws MojoExecutionException {
        try {
            JarFile jarFile = new JarFile(this.getArtifact().getFile());
            Manifest manifest = jarFile.getManifest();
            if (this.getBundleSymbolicName() == null) {
                String value = manifest.getMainAttributes().getValue(BUNDLE_SYMBOLIC_NAME);
                if (value == null) {
                    throw new MojoExecutionException("Bundle-SymbolicName cannot be found in the bundle: " + this.getArtifact().getFile());
                }
                String[] split = value.split(";");
                this.setBundleSymbolicName(split[0]);
            }
            if (this.getBundleVersion() == null) {
                this.setBundleVersion(manifest.getMainAttributes().getValue(BUNDLE_VERSION));
            }
            jarFile.close();
            if (this.getBundleSymbolicName() == null || this.getBundleVersion() == null) {
                throw new MojoExecutionException("Artifact doesn't contain OSGI info: " + this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to retreive osgi bundle info: " + this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion(), (Exception)e);
        }
    }
}

