/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.humantask.artifact;

import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.wso2.maven.humantask.artifact.util.FileManagementUtils;

@Mojo(name="buildHumanTask")
public class HumanTaskMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.basedir}")
    private File path;
    @Parameter(defaultValue="zip")
    private String type;
    @Parameter(defaultValue="false")
    private boolean enableArchive;
    @Parameter(defaultValue="${project}")
    private MavenProject mavenProject;
    private MavenProjectHelper projectHelper;
    private static final String HUMANTASK_CONTENT_DIR = "humantaskcontent";

    public void execute() throws MojoExecutionException, MojoFailureException {
        File project = this.path;
        File humanTaskContentDir = new File(project, HUMANTASK_CONTENT_DIR);
        this.createZip(humanTaskContentDir);
    }

    public void createZip(File project) throws MojoExecutionException {
        try {
            String artifactType = this.getType();
            String artifactName = this.mavenProject.getArtifactId() + "-" + this.mavenProject.getVersion() + "." + artifactType;
            File archive = FileManagementUtils.createArchive(this.path, project, artifactName);
            if (archive == null || !archive.exists()) {
                throw new MojoExecutionException(archive + " is null or doesn't exist");
            }
            this.mavenProject.getArtifact().setFile(archive);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while creating Human Task archive", e);
        }
    }

    public String getHumanTaskProjectName(File project) {
        List fileList = (List)FileUtils.listFiles((File)project, null, null);
        String humanTaskProjectName = project.getName();
        for (File file : fileList) {
            if (file.isDirectory() || !file.getName().toLowerCase().endsWith(".ht")) continue;
            humanTaskProjectName = file.getParent();
            return humanTaskProjectName;
        }
        return humanTaskProjectName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setEnableArchive(boolean enableArchive) {
        this.enableArchive = enableArchive;
    }

    public boolean isEnableArchive() {
        return this.enableArchive;
    }
}

