/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.humantask.artifact.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FileManagementUtils {
    private static final Logger logger = Logger.getLogger(FileManagementUtils.class);

    public static File createArchive(File location, File artifactLocation, String artifactName) throws Exception {
        File zipFolder;
        File targetFolder = new File(location.getPath(), "target");
        File humantaskDataFolder = new File(targetFolder, "ht-tmp");
        if (!humantaskDataFolder.mkdirs()) {
            logger.error((Object)"Error creating corresponding ZIP file");
        }
        if (!(zipFolder = new File(humantaskDataFolder, artifactLocation.getName())).mkdirs()) {
            logger.error((Object)"Error creating corresponding ZIP file");
        }
        FileUtils.copyDirectory((File)artifactLocation, (File)zipFolder);
        File zipFile = new File(targetFolder, artifactName);
        FileManagementUtils.zipFolder(zipFolder.getAbsolutePath(), zipFile.toString());
        FileUtils.deleteDirectory((File)humantaskDataFolder);
        return zipFile;
    }

    public static void zipFolder(String srcFolder, String destZipFile) {
        try (FileOutputStream fileWriter = new FileOutputStream(destZipFile);
             ZipOutputStream zip = new ZipOutputStream(fileWriter);){
            FileManagementUtils.addFolderContentsToZip(srcFolder, zip);
            zip.flush();
        }
        catch (IOException ex) {
            logger.error((Object)"Error creating corresponding ZIP file", (Throwable)ex);
        }
    }

    private static void addToZip(String path, String srcFile, ZipOutputStream zip) {
        File folder = new File(srcFile);
        if (folder.isDirectory()) {
            FileManagementUtils.addFolderToZip(path, srcFile, zip);
        } else if (!srcFile.equals(".project")) {
            byte[] buf = new byte[1024];
            try (FileInputStream in = new FileInputStream(srcFile);){
                int len;
                String location = folder.getName();
                if (!StringUtils.isBlank((String)path)) {
                    location = path + File.separator + folder.getName();
                }
                zip.putNextEntry(new ZipEntry(location));
                while ((len = in.read(buf)) > 0) {
                    zip.write(buf, 0, len);
                }
            }
            catch (IOException e) {
                logger.error((Object)"Error creating corresponding ZIP file", (Throwable)e);
            }
        }
    }

    private static void addFolderContentsToZip(String srcFolder, ZipOutputStream zip) {
        File folder = new File(srcFolder);
        String[] fileListArray = folder.list();
        if (fileListArray != null) {
            for (int i = 0; i < fileListArray.length; ++i) {
                FileManagementUtils.addToZip("", srcFolder + File.separator + fileListArray[i], zip);
            }
        }
    }

    private static void addFolderToZip(String path, String srcFolder, ZipOutputStream zip) {
        File folder = new File(srcFolder);
        String[] fileListArray = folder.list();
        if (fileListArray != null) {
            for (int i = 0; i < fileListArray.length; ++i) {
                String newPath = folder.getName();
                if (!StringUtils.isBlank((String)path)) {
                    newPath = path + File.separator + newPath;
                }
                FileManagementUtils.addToZip(newPath, srcFolder + File.separator + fileListArray[i], zip);
            }
        }
    }
}

