/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.car.artifact;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.activation.DataHandler;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.commons.httpclient.Header;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.wso2.carbon.application.mgt.stub.upload.types.carbon.UploadedFileItem;
import org.wso2.carbon.stub.ApplicationAdminStub;
import org.wso2.carbon.stub.CarbonAppUploaderStub;
import org.wso2.maven.car.artifact.CAppHandler;

public class EICAppHandler
implements CAppHandler {
    private final Log logger;

    public EICAppHandler(Log logger) {
        this.logger = logger;
    }

    @Override
    public void deployCApp(String username, String password, String serverUrl, File carFile) throws Exception {
        CarbonAppUploaderStub carbonAppUploaderStub = this.getCarbonAppUploaderStub(username, password, serverUrl);
        UploadedFileItem uploadedFileItem = new UploadedFileItem();
        DataHandler param = new DataHandler(carFile.toURI().toURL());
        uploadedFileItem.setDataHandler(param);
        uploadedFileItem.setFileName(carFile.getName());
        uploadedFileItem.setFileType("jar");
        UploadedFileItem[] fileItems = new UploadedFileItem[]{uploadedFileItem};
        this.logger.info((CharSequence)("Uploading " + carFile.getName() + " to " + serverUrl + "..."));
        carbonAppUploaderStub.uploadApp(fileItems);
    }

    @Override
    public void unDeployCApp(String username, String password, String serverUrl, MavenProject project) throws Exception {
        ApplicationAdminStub appAdminStub = this.getApplicationAdminStub(serverUrl, username, password);
        String[] existingApplications = appAdminStub.listAllApplications();
        if (existingApplications != null && Arrays.asList(existingApplications).contains(project.getArtifactId() + "_" + project.getVersion())) {
            appAdminStub.deleteApplication(project.getArtifactId() + "_" + project.getVersion());
            this.logger.info((CharSequence)("Located the C-App " + project.getArtifactId() + "_" + project.getVersion() + " and undeployed..."));
        }
    }

    private CarbonAppUploaderStub getCarbonAppUploaderStub(String username, String pwd, String url) throws Exception {
        CarbonAppUploaderStub carbonAppUploaderStub = new CarbonAppUploaderStub(url + "/services/CarbonAppUploader");
        Header header = this.createBasicAuthHeader(username, pwd);
        ArrayList<Header> list = new ArrayList<Header>();
        list.add(header);
        carbonAppUploaderStub._getServiceClient().getOptions().setProperty("HTTP_HEADERS", list);
        return carbonAppUploaderStub;
    }

    private ApplicationAdminStub getApplicationAdminStub(String serverURL, String username, String pwd) throws Exception {
        ApplicationAdminStub appAdminStub = new ApplicationAdminStub(serverURL + "/services/ApplicationAdmin");
        Header header = this.createBasicAuthHeader(username, pwd);
        ArrayList<Header> list = new ArrayList<Header>();
        list.add(header);
        appAdminStub._getServiceClient().getOptions().setProperty("HTTP_HEADERS", list);
        return appAdminStub;
    }

    private Header createBasicAuthHeader(String userName, String password) {
        return new Header("Authorization", "Basic " + Base64Utils.encode((byte[])(userName + ":" + password).getBytes()));
    }
}

