/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.car.artifact.impl;

import feign.Client;
import feign.Feign;
import feign.Request;
import feign.RequestInterceptor;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormEncoder;
import org.wso2.maven.car.artifact.HTTPClientBuilderService;
import org.wso2.maven.car.artifact.impl.JWTAuthRequestInterceptor;

public class HTTPClientBuilderServiceImpl
implements HTTPClientBuilderService {
    @Override
    public Client newDefaultClientInstance() {
        return new Client.Default(null, null);
    }

    @Override
    public <T> T buildWithBasicAuth(String username, String password, int connectTimeoutMillis, int readTimeoutMillis, Class<T> target, String url) {
        return (T)Feign.builder().requestInterceptor((RequestInterceptor)new BasicAuthRequestInterceptor(username, password)).encoder((Encoder)new Encoder.Default()).decoder((Decoder)new Decoder.Default()).options(new Request.Options(connectTimeoutMillis, readTimeoutMillis)).client(this.newDefaultClientInstance()).target(target, url);
    }

    @Override
    public <T> T buildWithJWTAndFormEncoder(String accessToken, int connectTimeoutMillis, int readTimeoutMillis, Class<T> target, String url) {
        return (T)Feign.builder().requestInterceptor((RequestInterceptor)new JWTAuthRequestInterceptor(accessToken)).encoder((Encoder)new FormEncoder()).decoder((Decoder)new Decoder.Default()).options(new Request.Options(connectTimeoutMillis, readTimeoutMillis)).client(this.newDefaultClientInstance()).target(target, url);
    }

    @Override
    public <T> T buildWithJWT(String accessToken, int connectTimeoutMillis, int readTimeoutMillis, Class<T> target, String url) {
        return (T)Feign.builder().requestInterceptor((RequestInterceptor)new JWTAuthRequestInterceptor(accessToken)).encoder((Encoder)new Encoder.Default()).decoder((Decoder)new Decoder.Default()).options(new Request.Options(connectTimeoutMillis, readTimeoutMillis)).client(this.newDefaultClientInstance()).target(target, url);
    }
}

