/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.car.artifact;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.wso2.maven.car.artifact.CAppHandler;
import org.wso2.maven.car.artifact.CarbonServer;
import org.wso2.maven.car.artifact.EICAppHandler;
import org.wso2.maven.car.artifact.MICAppHandler;

public class DeployCarMojo
extends AbstractMojo {
    private static final String EXTENSION_CAR = ".car";
    private String trustStorePath;
    private String trustStorePassword;
    private String trustStoreType;
    private String serverUrl;
    private String userName;
    private String password;
    private File target;
    private File archiveLocation;
    public String finalName;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private ArtifactRepository localRepository;
    private List<?> remoteRepositories;
    private String operation;
    private String serverType;
    private List<CarbonServer> carbonServers;
    private boolean skip;
    private CAppHandler cAppHandler;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping CAR artifact deployment to Carbon Server(s).");
            return;
        }
        if (this.carbonServers == null) {
            this.getLog().info((CharSequence)"Could not find <carbonServers> element in the pom.xml. Hence proceeding with default values");
            this.process();
        } else if (this.carbonServers != null && this.carbonServers.isEmpty()) {
            this.getLog().info((CharSequence)"Could not find properties under <carbonServer> element in the pom.xml. Hence proceeding with default values");
            this.process();
        } else {
            for (CarbonServer server : this.carbonServers) {
                this.getLog().info((CharSequence)"Deploying to Server...");
                this.getLog().info((CharSequence)("TSPath=" + server.getTrustStorePath()));
                if (server.getTrustStorePath() != null) {
                    this.trustStorePath = server.getTrustStorePath();
                }
                if (server.getTrustStorePassword() != null) {
                    this.trustStorePassword = server.getTrustStorePassword();
                }
                this.getLog().info((CharSequence)("TSType=" + server.getTrustStoreType()));
                if (server.getTrustStoreType() != null) {
                    this.trustStoreType = server.getTrustStoreType();
                }
                this.getLog().info((CharSequence)("Server URL=" + server.getServerUrl()));
                if (server.getServerUrl() != null) {
                    this.serverUrl = server.getServerUrl();
                }
                if (server.getUserName() != null) {
                    this.userName = server.getUserName();
                }
                if (server.getPassword() != null) {
                    this.password = server.getPassword();
                }
                this.getLog().info((CharSequence)("Operation=" + server.getOperation()));
                if (server.getOperation() != null) {
                    this.operation = server.getOperation();
                }
                if (server.getServerType() != null) {
                    this.serverType = server.getServerType();
                }
                this.getLog().info((CharSequence)("ServerType=" + this.serverType));
                this.process();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void process() throws MojoExecutionException {
        this.setSystemProperties();
        List buildPlugins = this.project.getBuildPlugins();
        for (Plugin plugin : buildPlugins) {
            String artifactId = plugin.getArtifactId();
            if (!artifactId.equals("maven-car-plugin")) continue;
            Xpp3Dom configurationNode = (Xpp3Dom)plugin.getConfiguration();
            Xpp3Dom finalNameNode = configurationNode.getChild("finalName");
            if (finalNameNode == null) break;
            this.finalName = finalNameNode.getValue();
            this.getLog().info((CharSequence)("Final Name of C-App: " + this.finalName + EXTENSION_CAR));
            break;
        }
        File carFile = null;
        if (null != this.archiveLocation) {
            if (!this.archiveLocation.isFile() || !this.archiveLocation.getName().endsWith(EXTENSION_CAR)) throw new MojoExecutionException("Archive location is not a valid file");
            carFile = this.archiveLocation;
        } else {
            carFile = this.finalName == null ? new File(this.target + File.separator + this.project.getArtifactId() + "_" + this.project.getVersion() + EXTENSION_CAR) : new File(this.target + File.separator + this.finalName + EXTENSION_CAR);
        }
        if (!this.isValidServerType()) {
            throw new MojoExecutionException("Unsupported serverType. Only allows \"mi\" or \"ei\" ");
        }
        this.cAppHandler = this.getCAppHandler();
        if (this.operation.equalsIgnoreCase("deploy")) {
            try {
                this.cAppHandler.deployCApp(this.userName, this.password, this.serverUrl, carFile);
                return;
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Uploading " + carFile.getName() + " to " + this.serverUrl + " Failed."), (Throwable)e);
                throw new MojoExecutionException("Deploying " + carFile.getName() + " to " + this.serverUrl + " Failed.", e);
            }
        }
        if (!this.operation.equalsIgnoreCase("undeploy")) throw new MojoExecutionException("Unsupported operation. Only allows \"deploy\" or \"undeploy\" ");
        try {
            this.cAppHandler.unDeployCApp(this.userName, this.password, this.serverUrl, this.project);
            return;
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Deleting " + carFile.getName() + " to " + this.serverUrl + " Failed."), (Throwable)e);
            throw new MojoExecutionException("Deleting " + carFile.getName() + " to " + this.serverUrl + " Failed.", e);
        }
    }

    private void printParams() {
        if (!this.carbonServers.isEmpty()) {
            for (CarbonServer server : this.carbonServers) {
                this.getLog().info((CharSequence)"Server:");
                this.getLog().info((CharSequence)("TSPath=" + server.getTrustStorePath()));
                this.getLog().info((CharSequence)("TSPWD=" + server.getTrustStorePassword()));
                this.getLog().info((CharSequence)("TSType=" + server.getTrustStoreType()));
                this.getLog().info((CharSequence)("Server URL=" + server.getServerUrl()));
                this.getLog().info((CharSequence)("Operation=" + server.getOperation()));
                if (server.getUserName() != null) continue;
                this.getLog().info((CharSequence)"Please enter a valid user name.");
            }
        }
    }

    private void setSystemProperties() {
        System.setProperty("javax.net.ssl.trustStore", this.trustStorePath);
        System.setProperty("javax.net.ssl.trustStorePassword", this.trustStorePassword);
        System.setProperty("javax.net.ssl.trustStoreType", this.trustStoreType);
    }

    private boolean isValidServerType() {
        return this.serverType.equalsIgnoreCase("mi") || this.serverType.equalsIgnoreCase("ei");
    }

    private CAppHandler getCAppHandler() {
        if (this.serverType.equalsIgnoreCase("ei")) {
            return new EICAppHandler(this.getLog());
        }
        return new MICAppHandler(this.getLog());
    }
}

