/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.car.artifact.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class FileManagementUtil {
    private static final int BUFFER = 2048;

    public static void copyDirectory(File srcPath, File dstPath, List filesToBeCopied) throws IOException {
        if (srcPath.isDirectory()) {
            if (!dstPath.exists()) {
                dstPath.mkdir();
            }
            String[] files = srcPath.list();
            for (int i = 0; i < files.length; ++i) {
                FileManagementUtil.copyDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]), filesToBeCopied);
            }
        } else {
            if (!filesToBeCopied.contains(srcPath.getAbsolutePath())) {
                return;
            }
            if (!srcPath.exists()) {
                return;
            }
            FileManagementUtil.copy(srcPath, dstPath);
        }
    }

    public static List getAllFilesPresentInFolder(File srcPath) {
        ArrayList<String> fileList = new ArrayList<String>();
        if (srcPath.isDirectory()) {
            String[] files = srcPath.list();
            for (int i = 0; i < files.length; ++i) {
                fileList.addAll(FileManagementUtil.getAllFilesPresentInFolder(new File(srcPath, files[i])));
            }
        } else {
            fileList.add(srcPath.getAbsolutePath());
        }
        return fileList;
    }

    public static void removeEmptyDirectories(File srcPath) {
        if (srcPath.isDirectory()) {
            String[] files = srcPath.list();
            for (int i = 0; i < files.length; ++i) {
                FileManagementUtil.removeEmptyDirectories(new File(srcPath, files[i]));
            }
            if (srcPath.list().length == 0) {
                srcPath.delete();
            }
        }
    }

    public static void zipFolder(String srcFolder, String destZipFile) {
        ZipOutputStream zip = null;
        FileOutputStream fileWriter = null;
        try {
            fileWriter = new FileOutputStream(destZipFile);
            zip = new ZipOutputStream(fileWriter);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        FileManagementUtil.addFolderContentsToZip(srcFolder, zip);
        try {
            zip.flush();
            zip.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void addToZip(String path, String srcFile, ZipOutputStream zip) {
        File folder = new File(srcFile);
        if (folder.isDirectory()) {
            FileManagementUtil.addFolderToZip(path, srcFile, zip);
        } else {
            byte[] buf = new byte[1024];
            try {
                int len;
                FileInputStream in = new FileInputStream(srcFile);
                if (path.trim().equals("")) {
                    zip.putNextEntry(new ZipEntry(folder.getName()));
                } else {
                    zip.putNextEntry(new ZipEntry(path + "/" + folder.getName()));
                }
                while ((len = in.read(buf)) > 0) {
                    zip.write(buf, 0, len);
                }
                in.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static void addFolderContentsToZip(String srcFolder, ZipOutputStream zip) {
        File folder = new File(srcFolder);
        String[] fileListe = folder.list();
        try {
            for (int i = 0; fileListe.length != i; ++i) {
                if (new File(folder, fileListe[i]).isDirectory()) {
                    zip.putNextEntry(new ZipEntry(fileListe[i] + "/"));
                    zip.closeEntry();
                }
                FileManagementUtil.addToZip("", srcFolder + "/" + fileListe[i], zip);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addFolderToZip(String path, String srcFolder, ZipOutputStream zip) {
        File folder = new File(srcFolder);
        String[] fileListe = folder.list();
        try {
            for (int i = 0; fileListe.length != i; ++i) {
                String newPath = folder.getName();
                if (!path.equalsIgnoreCase("")) {
                    newPath = path + "/" + newPath;
                }
                if (new File(folder, fileListe[i]).isDirectory()) {
                    zip.putNextEntry(new ZipEntry(newPath + "/" + fileListe[i] + "/"));
                }
                FileManagementUtil.addToZip(newPath, srcFolder + "/" + fileListe[i], zip);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String src, String dest) {
        FileInputStream is = null;
        FileOutputStream fos = null;
        try {
            is = new FileInputStream(src);
            fos = new FileOutputStream(dest);
            int c = 0;
            byte[] array = new byte[1024];
            while ((c = ((InputStream)is).read(array)) >= 0) {
                fos.write(array, 0, c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fos.close();
                ((InputStream)is).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static File createFileAndParentDirectories(String fileName) throws Exception {
        File file = new File(fileName);
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        file.createNewFile();
        return file;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileManagementUtil.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void deleteDirectories(File dir) {
        File[] children = dir.listFiles();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].list() != null && children[i].list().length > 0) {
                FileManagementUtil.deleteDirectories(children[i]);
                continue;
            }
            children[i].delete();
        }
        dir.delete();
    }

    public static void deleteDirectories(String dir) {
        File directory = new File(dir);
        FileManagementUtil.deleteDirectories(directory);
    }

    public static void createTargetFile(String sourceFileName, String targetFileName) throws Exception {
        FileManagementUtil.createTargetFile(sourceFileName, targetFileName, false);
    }

    public static void createTargetFile(String sourceFileName, String targetFileName, boolean overwrite) throws Exception {
        File idealResultFile = new File(targetFileName);
        if (overwrite || !idealResultFile.exists()) {
            FileManagementUtil.createFileAndParentDirectories(targetFileName);
            FileManagementUtil.copyFile(sourceFileName, targetFileName);
        }
    }

    public static boolean createDirectory(String directory) {
        boolean success = new File(directory).mkdir();
        if (!success) {
            // empty if block
        }
        return success;
    }

    public static boolean createDirectorys(String directory) {
        boolean success = new File(directory).mkdirs();
        if (!success) {
            // empty if block
        }
        return success;
    }

    public static void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdirs();
            }
            String[] children = srcDir.list();
            for (int i = 0; i < children.length; ++i) {
                FileManagementUtil.copyDirectory(new File(srcDir, children[i]), new File(dstDir, children[i]));
            }
        } else {
            FileManagementUtil.copy(srcDir, dstDir);
        }
    }

    public static void copy(File src, File dst) throws IOException {
        int len;
        if (dst.getParentFile() != null && !dst.getParentFile().exists()) {
            dst.getParentFile().mkdirs();
        }
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static String addAnotherNodeToPath(String currentPath, String newNode) {
        return currentPath + File.separator + newNode;
    }

    public static String addNodesToPath(String currentPath, String[] newNode) {
        String returnPath = currentPath;
        for (int i = 0; i < newNode.length; ++i) {
            returnPath = returnPath + File.separator + newNode[i];
        }
        return returnPath;
    }

    public static String addNodesToPath(StringBuffer currentPath, String[] pathNodes) {
        for (int i = 0; i < pathNodes.length; ++i) {
            currentPath.append(File.separator);
            currentPath.append(pathNodes[i]);
        }
        return currentPath.toString();
    }

    public static String addNodesToURL(String currentPath, String[] newNode) {
        String returnPath = currentPath;
        for (int i = 0; i < newNode.length; ++i) {
            returnPath = returnPath + "/" + newNode[i];
        }
        return returnPath;
    }

    public static File[] getMatchingFiles(String sourceDir, String fileNamePrefix, String extension) {
        ArrayList<File> fileList = new ArrayList<File>();
        File libDir = new File(sourceDir);
        String libDirPath = libDir.getAbsolutePath();
        String[] items = libDir.list();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                String item = items[i];
                if (fileNamePrefix != null && extension != null) {
                    if (!item.startsWith(fileNamePrefix) || !item.endsWith(extension)) continue;
                    fileList.add(new File(libDirPath + File.separator + item));
                    continue;
                }
                if (fileNamePrefix == null && extension != null) {
                    if (!item.endsWith(extension)) continue;
                    fileList.add(new File(libDirPath + File.separator + item));
                    continue;
                }
                if (fileNamePrefix != null && extension == null) {
                    if (!item.startsWith(fileNamePrefix)) continue;
                    fileList.add(new File(libDirPath + File.separator + item));
                    continue;
                }
                fileList.add(new File(libDirPath + File.separator + item));
            }
            return fileList.toArray(new File[fileList.size()]);
        }
        return new File[0];
    }

    public static void filterOutRestrictedFiles(String sourceDir, String fileNamePrefix, String extension) {
        File[] resultedMatchingFiles = FileManagementUtil.getMatchingFiles(sourceDir, fileNamePrefix, extension);
        for (int i = 0; i < resultedMatchingFiles.length; ++i) {
            File matchingFilePath = new File(resultedMatchingFiles[i].getAbsolutePath());
            matchingFilePath.delete();
        }
    }

    public static void unzip(File archiveFile, File destination) throws Exception {
        ZipEntry entry;
        BufferedOutputStream dest = null;
        FileInputStream fis = new FileInputStream(archiveFile);
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
        File base = destination;
        while ((entry = zis.getNextEntry()) != null) {
            int count;
            byte[] data = new byte[2048];
            File file = new File(base, entry.getName());
            if (entry.getName().endsWith("/")) {
                file.mkdirs();
                continue;
            }
            if (file.getParentFile() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(file);
            dest = new BufferedOutputStream(fos, 2048);
            while ((count = zis.read(data, 0, 2048)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
        }
        zis.close();
        fis.close();
    }
}

