/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.registry;

import java.io.File;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.xml.stream.FactoryConfigurationError;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.wso2.maven.core.model.AbstractXMLDoc;
import org.wso2.maven.registry.beans.RegistryCollection;
import org.wso2.maven.registry.beans.RegistryElement;
import org.wso2.maven.registry.beans.RegistryItem;
import org.wso2.maven.registry.beans.RegistryProperty;

public abstract class RegistryInfoProvider
extends AbstractXMLDoc
implements Observer {
    private File source;
    private static final String FILE = "file";
    private static final String PATH = "path";
    private static final String MEDIA_TYPE = "mediaType";
    private static final String DIRECTORY = "directory";
    private static final String PROPERTIES = "properties";
    private static final String PROPERTY = "property";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    static final String ITEM = "item";
    static final String COLLECTION = "collection";
    static final String EMPTY_STRING = "";

    public void update(Observable o, Object arg) {
    }

    RegistryItem getRegistryItem(OMElement omElement) {
        RegistryItem item = new RegistryItem();
        item.setFile(((OMElement)this.getChildElements(omElement, FILE).get(0)).getText());
        item.setPath(((OMElement)this.getChildElements(omElement, PATH).get(0)).getText());
        List mediaTypeElements = this.getChildElements(omElement, MEDIA_TYPE);
        if (!mediaTypeElements.isEmpty()) {
            item.setMediaType(((OMElement)mediaTypeElements.get(0)).getText());
        }
        this.setPropertiesToRegistryElement(omElement, item);
        return item;
    }

    RegistryCollection getRegistryCollection(OMElement omElement) {
        RegistryCollection collection = new RegistryCollection();
        collection.setDirectory(((OMElement)this.getChildElements(omElement, DIRECTORY).get(0)).getText());
        collection.setPath(((OMElement)this.getChildElements(omElement, PATH).get(0)).getText());
        this.setPropertiesToRegistryElement(omElement, collection);
        return collection;
    }

    private void setPropertiesToRegistryElement(OMElement omElement, RegistryElement element) {
        List propertiesElement = this.getChildElements(omElement, PROPERTIES);
        if (propertiesElement.isEmpty()) {
            return;
        }
        OMElement properties = (OMElement)propertiesElement.get(0);
        List propertyList = this.getChildElements(properties, PROPERTY);
        for (OMElement property : propertyList) {
            element.addProperty(new RegistryProperty(this.getAttribute(property, KEY), this.getAttribute(property, VALUE)));
        }
    }

    OMElement getRegistryElementInfo(RegistryElement item) {
        OMElement element3;
        OMElement element2;
        OMElement element = null;
        if (item instanceof RegistryItem) {
            element = this.getElement(ITEM, EMPTY_STRING);
            element2 = this.getElement(FILE, ((RegistryItem)item).getFile());
            element3 = this.getElement(PATH, item.getPath());
            OMElement element4 = this.getElement(MEDIA_TYPE, ((RegistryItem)item).getMediaType());
            element.addChild((OMNode)element2);
            element.addChild((OMNode)element3);
            element.addChild((OMNode)element4);
        } else if (item instanceof RegistryCollection) {
            element = this.getElement(COLLECTION, EMPTY_STRING);
            element2 = this.getElement(DIRECTORY, ((RegistryCollection)item).getDirectory());
            element3 = this.getElement(PATH, item.getPath());
            element.addChild((OMNode)element2);
            element.addChild((OMNode)element3);
        }
        if (element != null) {
            OMElement propertiesElement = this.getElement(PROPERTIES, EMPTY_STRING);
            List<RegistryProperty> registryPropertyList = item.getProperties();
            for (RegistryProperty registryProperty : registryPropertyList) {
                OMElement propertyElement = this.getElement(PROPERTY, EMPTY_STRING);
                this.addAttribute(propertyElement, KEY, registryProperty.getKey());
                this.addAttribute(propertyElement, VALUE, registryProperty.getValue());
                propertiesElement.addChild((OMNode)propertyElement);
            }
            element.addChild((OMNode)propertiesElement);
        }
        return element;
    }

    protected abstract void deserialize(OMElement var1) throws Exception;

    protected String serialize() throws Exception {
        String result = null;
        OMDocument document = factory.createOMDocument();
        OMElement documentElement = this.getDocumentElement();
        document.addChild((OMNode)documentElement);
        try {
            result = this.getPretifiedString(documentElement);
        }
        catch (Exception e) {
            new SystemStreamLog().error((CharSequence)"Error occurred while prettifying the OMElement. ", (Throwable)e);
            return null;
        }
        return result;
    }

    protected String getDefaultName() {
        return null;
    }

    public void setSource(File source) {
        this.source = source;
    }

    public File getSource() {
        return this.source;
    }

    public File toFile() throws Exception {
        return new File(this.toFile(this.getSource()).toString());
    }

    public void fromFile(File file) throws FactoryConfigurationError, Exception {
        this.setSource(file);
        if (this.getSource().exists()) {
            this.deserialize(this.getSource());
        }
    }

    public abstract OMElement getDocumentElement();
}

