/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.libraries;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.wso2.maven.CARMojo;
import org.wso2.maven.MavenUtils;
import org.wso2.maven.libraries.LibraryResolverException;
import org.yaml.snakeyaml.Yaml;

public class ConnectorDependencyResolver {
    public static void resolveDependencies(CARMojo carMojo) throws Exception {
        String extractedDir = "target" + File.separator + "extracted-connectors";
        String libDir = "target" + File.separator + "libs";
        new File(extractedDir).mkdirs();
        new File(libDir).mkdirs();
        String mavenHome = MavenUtils.getMavenHome();
        DefaultInvoker invoker = new DefaultInvoker();
        MavenUtils.setupInvoker(mavenHome, (Invoker)invoker);
        List<File> connectorZips = ConnectorDependencyResolver.resolveConnectorZips("pom.xml", (Invoker)invoker);
        ArrayList<File> dependencyFiles = new ArrayList<File>();
        for (File zipFile : connectorZips) {
            String targetExtractDir = extractedDir + File.separator + zipFile.getName().replace(".zip", "");
            ConnectorDependencyResolver.extractZipFile(zipFile, targetExtractDir);
            File descriptorYaml = new File(targetExtractDir + File.separator + "descriptor.yml");
            if (!descriptorYaml.exists()) continue;
            carMojo.getLog().info((CharSequence)("Found descriptor file: " + descriptorYaml.getPath()));
            dependencyFiles.add(descriptorYaml);
        }
        if (!dependencyFiles.isEmpty()) {
            for (File dependencyFile : dependencyFiles) {
                carMojo.logInfo("Resolving dependencies for " + dependencyFile.getPath());
                ConnectorDependencyResolver.resolveMavenDependencies(dependencyFile, libDir, (Invoker)invoker, carMojo);
            }
        }
        carMojo.logInfo("All dependencies resolved and extracted successfully.");
    }

    private static List<File> resolveConnectorZips(String pomFilePath, Invoker invoker) throws MavenInvocationException {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(new File(pomFilePath));
        request.setGoals(Collections.singletonList("dependency:copy-dependencies -DincludeTypes=zip"));
        invoker.execute((InvocationRequest)request);
        File dependenciesDir = new File("target" + File.separator + "dependency");
        if (!dependenciesDir.exists()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<File> connectorZips = new ArrayList<File>();
        for (File file : dependenciesDir.listFiles()) {
            if (!file.getName().endsWith(".zip")) continue;
            connectorZips.add(file);
        }
        return connectorZips;
    }

    private static void extractZipFile(File zipFile, String outputDir) throws IOException {
        byte[] buffer = new byte[1024];
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            File newFile = ConnectorDependencyResolver.newFile(outputDir, zipEntry);
            if (zipEntry.isDirectory()) {
                newFile.mkdirs();
            } else {
                new File(newFile.getParent()).mkdirs();
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    int len;
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                }
            }
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    private static File newFile(String outputDir, ZipEntry zipEntry) {
        String fileName = zipEntry.getName();
        return new File(outputDir + File.separator + fileName);
    }

    private static void resolveMavenDependencies(File descriptorYaml, String libDir, Invoker invoker, CARMojo carMojo) throws Exception {
        List dependencies;
        if (!descriptorYaml.exists()) {
            return;
        }
        Yaml yaml = new Yaml();
        Map yamlData = (Map)yaml.load(Files.newInputStream(descriptorYaml.toPath(), new OpenOption[0]));
        List repositories = (List)yamlData.get("repositories");
        StringBuilder repositoriesUrl = new StringBuilder();
        if (repositories != null) {
            for (int i = 0; i < repositories.size(); ++i) {
                if (i > 0) {
                    repositoriesUrl.append(",");
                }
                repositoriesUrl.append((String)((Map)repositories.get(i)).get("url"));
            }
        }
        if ((dependencies = (List)yamlData.get("dependencies")) != null) {
            for (Map dependency : dependencies) {
                String groupId = (String)dependency.get("groupId");
                String artifactId = (String)dependency.get("artifactId");
                String version = (String)dependency.get("version");
                ConnectorDependencyResolver.resolveMavenDependency(groupId, artifactId, version, invoker, carMojo, repositoriesUrl.toString());
                ConnectorDependencyResolver.copyMavenDependency(groupId, artifactId, version, libDir, invoker, carMojo);
            }
        }
    }

    private static void resolveMavenDependency(String groupId, String artifactId, String version, Invoker invoker, CARMojo carMojo, String repositories) throws LibraryResolverException {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setGoals(Collections.singletonList(String.format("dependency:get -DgroupId=%s -DartifactId=%s -Dtransitive=false -Dversion=%s -DremoteRepositories=\"%s\"", groupId, artifactId, version, repositories)));
        ConnectorDependencyResolver.executeRequest((InvocationRequest)request, "Failed to resolve Maven dependency: " + groupId + ":" + artifactId + ":" + version, invoker, carMojo);
    }

    private static void copyMavenDependency(String groupId, String artifactId, String version, String libDir, Invoker invoker, CARMojo carMojo) throws LibraryResolverException {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setGoals(Collections.singletonList(String.format("dependency:copy -Dartifact=%s:%s:%s -DoutputDirectory=\"%s\" -DlocalRepositoryDirectory=\"%s\" -Dmaven.legacyLocalRepo=true", groupId, artifactId, version, libDir, libDir)));
        ConnectorDependencyResolver.executeRequest((InvocationRequest)request, "Failed to copy Maven dependency: " + groupId + ":" + artifactId + ":" + version, invoker, carMojo);
    }

    private static void executeRequest(InvocationRequest request, String errorMessage, Invoker invoker, CARMojo carMojo) throws LibraryResolverException {
        try {
            InvocationResult result = invoker.execute(request);
            if (result.getExitCode() != 0) {
                carMojo.logError(errorMessage);
                if (result.getExecutionException() != null) {
                    carMojo.logError(result.getExecutionException().getMessage());
                }
                throw new LibraryResolverException(errorMessage);
            }
        }
        catch (MavenInvocationException e) {
            throw new LibraryResolverException(errorMessage, e);
        }
    }
}

