/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.libraries;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.wso2.maven.CARMojo;
import org.wso2.maven.MavenUtils;
import org.wso2.maven.libraries.LibraryResolverException;
import org.yaml.snakeyaml.Yaml;

public class ConnectorDependencyResolver {
    public static void resolveDependencies(CARMojo carMojo) throws Exception {
        String extractedDir = "target" + File.separator + "extracted-connectors";
        String libDir = "target" + File.separator + "libs";
        new File(extractedDir).mkdirs();
        File libDirFile = new File(libDir);
        libDirFile.mkdirs();
        String libDirPath = libDirFile.getAbsolutePath();
        String mavenHome = MavenUtils.getMavenHome();
        DefaultInvoker invoker = new DefaultInvoker();
        MavenUtils.setupInvoker(mavenHome, (Invoker)invoker);
        List<File> connectorZips = ConnectorDependencyResolver.resolveConnectorZips("pom.xml", (Invoker)invoker);
        ArrayList<File> dependencyFiles = new ArrayList<File>();
        for (File zipFile : connectorZips) {
            String targetExtractDir = extractedDir + File.separator + zipFile.getName().replace(".zip", "");
            ConnectorDependencyResolver.extractZipFile(zipFile, targetExtractDir);
            File descriptorYaml = new File(targetExtractDir + File.separator + "descriptor.yml");
            if (!descriptorYaml.exists()) continue;
            carMojo.getLog().info((CharSequence)("Found descriptor file: " + descriptorYaml.getPath()));
            dependencyFiles.add(descriptorYaml);
        }
        if (!dependencyFiles.isEmpty()) {
            for (File dependencyFile : dependencyFiles) {
                carMojo.logInfo("Resolving dependencies for " + dependencyFile.getPath());
                ConnectorDependencyResolver.resolveMavenDependencies(dependencyFile, libDirPath, (Invoker)invoker, carMojo);
            }
        }
        carMojo.logInfo("All dependencies resolved and extracted successfully.");
    }

    private static List<File> resolveConnectorZips(String pomFilePath, Invoker invoker) throws MavenInvocationException {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(new File(pomFilePath));
        request.setGoals(Collections.singletonList("dependency:copy-dependencies -DincludeTypes=zip"));
        invoker.execute((InvocationRequest)request);
        File dependenciesDir = new File("target" + File.separator + "dependency");
        if (!dependenciesDir.exists()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<File> connectorZips = new ArrayList<File>();
        for (File file : dependenciesDir.listFiles()) {
            if (!file.getName().endsWith(".zip")) continue;
            connectorZips.add(file);
        }
        return connectorZips;
    }

    private static void extractZipFile(File zipFile, String outputDir) throws IOException {
        byte[] buffer = new byte[1024];
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            File newFile = ConnectorDependencyResolver.newFile(outputDir, zipEntry);
            if (zipEntry.isDirectory()) {
                newFile.mkdirs();
            } else {
                new File(newFile.getParent()).mkdirs();
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    int len;
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                }
            }
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    private static File newFile(String outputDir, ZipEntry zipEntry) {
        String fileName = zipEntry.getName();
        return new File(outputDir + File.separator + fileName);
    }

    private static void resolveMavenDependencies(File descriptorYaml, String libDir, Invoker invoker, CARMojo carMojo) throws Exception {
        if (!descriptorYaml.exists()) {
            return;
        }
        Yaml yaml = new Yaml();
        Map yamlData = (Map)yaml.load(Files.newInputStream(descriptorYaml.toPath(), new OpenOption[0]));
        List repositories = (List)yamlData.get("repositories");
        ArrayList<String> repositoriesList = new ArrayList<String>();
        if (repositories != null) {
            for (int i = 0; i < repositories.size(); ++i) {
                repositoriesList.add((String)((Map)repositories.get(i)).get("url"));
            }
        }
        List dependencies = (List)yamlData.get("dependencies");
        ArrayList<String> dependenciesList = new ArrayList<String>();
        if (dependencies != null) {
            for (Map dependency : dependencies) {
                String groupId = (String)dependency.get("groupId");
                String artifactId = (String)dependency.get("artifactId");
                String version = (String)dependency.get("version");
                dependenciesList.add(groupId + ":" + artifactId + ":" + version);
            }
        }
        ConnectorDependencyResolver.resolveAndCopyDependencies(dependenciesList, repositoriesList, libDir, invoker, carMojo);
    }

    public static void resolveAndCopyDependencies(List<String> dependencies, List<String> repositories, String libDir, Invoker invoker, CARMojo carMojo) throws LibraryResolverException {
        try {
            File tempPom = ConnectorDependencyResolver.createPomFile(dependencies, repositories);
            DefaultInvocationRequest request = new DefaultInvocationRequest();
            request.setPomFile(tempPom);
            request.setGoals(Collections.singletonList(String.format("dependency:copy-dependencies -DexcludeTransitive=true -DoutputDirectory=%s", libDir)));
            ConnectorDependencyResolver.executeRequest((InvocationRequest)request, "Failed to resolve and copy dependencies", invoker, carMojo);
            if (!tempPom.delete()) {
                carMojo.getLog().warn((CharSequence)("Failed to delete temporary pom.xml: " + tempPom.getAbsolutePath()));
            }
        }
        catch (IOException e) {
            throw new LibraryResolverException("Failed to create temporary pom.xml", e);
        }
    }

    private static File createPomFile(List<String> dependencies, List<String> repositories) throws IOException {
        File tempPom = File.createTempFile("temp-pom", ".xml");
        try (FileWriter writer = new FileWriter(tempPom);){
            writer.write("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n    <modelVersion>4.0.0</modelVersion>\n    <groupId>temp</groupId>\n    <artifactId>temp</artifactId>\n    <version>1.0-SNAPSHOT</version>\n    <dependencies>\n");
            for (String dependency : dependencies) {
                String[] parts = dependency.split(":");
                writer.write(String.format("        <dependency>\n            <groupId>%s</groupId>\n            <artifactId>%s</artifactId>\n            <version>%s</version>\n        </dependency>\n", parts[0], parts[1], parts[2]));
            }
            writer.write("    </dependencies>\n");
            if (repositories != null && !repositories.isEmpty()) {
                writer.write("    <repositories>\n");
                for (String repository : repositories) {
                    writer.write(String.format("        <repository>\n            <id>repo-%d</id>\n            <url>%s</url>\n        </repository>\n", repositories.indexOf(repository) + 1, repository));
                }
                writer.write("    </repositories>\n");
            }
            writer.write("</project>\n");
        }
        return tempPom;
    }

    private static void executeRequest(InvocationRequest request, String errorMessage, Invoker invoker, CARMojo carMojo) throws LibraryResolverException {
        try {
            InvocationResult result = invoker.execute(request);
            if (result.getExitCode() != 0) {
                carMojo.logError(errorMessage);
                if (result.getExecutionException() != null) {
                    carMojo.logError(result.getExecutionException().getMessage());
                }
                throw new LibraryResolverException(errorMessage);
            }
        }
        catch (MavenInvocationException e) {
            throw new LibraryResolverException(errorMessage, e);
        }
    }
}

