/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.Invoker;

public class MavenUtils {
    public static String getMavenHome() throws MojoExecutionException {
        String mavenHome = System.getProperty("maven.home");
        if (mavenHome != null) {
            return mavenHome;
        }
        mavenHome = System.getenv("M2_HOME");
        if (mavenHome != null) {
            return mavenHome;
        }
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            processBuilder.command("cmd.exe", "/c", "mvn -v");
        } else {
            processBuilder.command("sh", "-c", "mvn -v");
        }
        try {
            String line;
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (!line.contains("Maven home: ")) continue;
                return line.split("Maven home: ")[1].trim();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not determine Maven home.", (Exception)e);
        }
        throw new MojoExecutionException("Could not determine Maven home.");
    }

    public static void setupInvoker(String mavenHome, Invoker invoker) {
        invoker.setMavenHome(new File(mavenHome));
        invoker.setOutputHandler(new InvocationOutputHandler(){

            public void consumeLine(String line) {
                if (!line.contains("BUILD SUCCESS")) {
                    System.out.println(line);
                }
            }
        });
    }
}

