/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.wso2.maven.AbstractMavenReleaseMojo;

public class RollbackReleaseMojo
extends AbstractMavenReleaseMojo {
    protected static final String RELEASE_BACKUP_SFX = ".releaseBackup";
    protected static final String GOAL_NAME = "rollback";

    @Override
    protected String getGoal() {
        return GOAL_NAME;
    }

    @Override
    protected String getDryRunFilePrefix() {
        return null;
    }

    @Override
    protected boolean isInDryRunMode() {
        return false;
    }

    @Override
    protected String getCommitMessage(Properties releaseProperties) {
        return "rollback the release of " + releaseProperties.getProperty("scm.tag");
    }

    @Override
    protected String getNewVersion(File artifactXml) throws IOException, XmlPullParserException {
        File releaseBackupPOM = new File(artifactXml.getParent() + File.separator + "pom.xml" + RELEASE_BACKUP_SFX);
        if (releaseBackupPOM.exists()) {
            MavenProject mavenProjectBackup = this.getMavenProject(releaseBackupPOM);
            return mavenProjectBackup.getVersion();
        }
        this.log.error((CharSequence)("Cannot find " + releaseBackupPOM.getPath() + " file. Make sure you have invoked this goal before invoking release:rollback of maven-release-plugin."));
        return null;
    }
}

