/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.analysis.test;

import java.io.IOException;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.ml.integration.common.utils.MLBaseTest;
import org.wso2.carbon.ml.integration.common.utils.MLHttpClient;
import org.wso2.carbon.ml.integration.common.utils.exception.MLHttpClientException;

@Test(groups={"ml-analyses"})
public class CreateAnalysesTestCase
extends MLBaseTest {
    private MLHttpClient mlHttpclient;

    @BeforeClass(alwaysRun=true)
    public void initTest() throws Exception {
        super.init();
        this.mlHttpclient = this.getMLHttpClient();
        this.createDataset("Diabetes", "1.0", "artifacts/ML/data/pIndiansDiabetes.csv");
        this.isDatasetProcessed((Integer)this.getVersionSetIds().get(0), 120000L, 1000);
        this.createProject("Diabetes_Project", "Diabetes");
    }

    @Test(priority=1, description="Create an analysis")
    public void testCreateAnalysis() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.createAnalysis("Dummy_Analysis", this.mlHttpclient.getProjectId("Diabetes_Project"));
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=2, description="Create an existing analysis")
    public void testCreateExistingAnalysis() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.createAnalysis("Dummy_Analysis", this.mlHttpclient.getProjectId("Diabetes_Project"));
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(description="Create an analysis without a name")
    public void testCreateAnalysisWithoutName() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.createAnalysis(null, 1);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(description="Create an analysis without a ProjectId")
    public void testCreateAnalysisWithoutProjectID() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.createAnalysis("TestAnalysisForAnalysis", -1);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws MLHttpClientException {
        super.destroy();
    }
}

