/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.analysis.test;

import java.io.IOException;
import java.util.HashMap;
import javax.naming.NamingException;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.ml.integration.common.utils.MLBaseTest;
import org.wso2.carbon.ml.integration.common.utils.MLHttpClient;
import org.wso2.carbon.ml.integration.common.utils.exception.MLHttpClientException;

@Test(groups={"addModelConfigs"})
public class ModelConfigurationsTestCase
extends MLBaseTest {
    private MLHttpClient mlHttpclient;
    private int projectId;
    private int analysisId;
    private int analysisId2;
    private final String ALGORITHM_NAME = "LOGISTIC_REGRESSION";

    @BeforeClass(alwaysRun=true)
    public void initTest() throws Exception {
        super.init();
        this.mlHttpclient = this.getMLHttpClient();
        this.createDataset("Diabetes", "1.0", "artifacts/ML/data/pIndiansDiabetes.csv");
        this.isDatasetProcessed((Integer)this.getVersionSetIds().get(0), 120000L, 1000);
        this.projectId = this.createProject("Diabetes_Project", "Diabetes");
        this.analysisId = this.createAnalysis("Dummy_Analysis", this.projectId);
        this.analysisId2 = this.createAnalysis("Dummy_Analysis_2", this.projectId);
    }

    @Test(priority=1, description="Add model configurations to the analysis")
    public void testSetModelConfigurations() throws MLHttpClientException, IOException {
        HashMap<String, String> configurations = new HashMap<String, String>();
        configurations.put("algorithmName", "LOGISTIC_REGRESSION");
        configurations.put("algorithmType", "Classification");
        configurations.put("responseVariable", "Class");
        configurations.put("trainDataFraction", "0.7");
        CloseableHttpResponse response = this.mlHttpclient.setModelConfiguration(this.analysisId, configurations);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=2, description="Get response variable of the analyses")
    public void testGetResponseVariable() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/analyses/" + this.analysisId + "/responseVariables");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=2, description="Get response variable for malformed analysis id")
    public void testGetResponseVariableForMalformedAnalysisId() throws MLHttpClientException, NamingException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/analyses/abc/responseVariables");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.NOT_FOUND.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=2, description="Get algorithm of the analyses")
    public void testGetAlgorithm() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/analyses/" + this.analysisId + "/algorithmName");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=2, description="Get algorithm type of the analyses")
    public void testGetAlgorithmType() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/analyses/" + this.analysisId + "/algorithmType");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=2, description="Get train data fraction of the analyses")
    public void testGetTrainDataFractionType() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/analyses/" + this.analysisId + "/trainDataFraction");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=3, description="Set default values to hyperparameters")
    public void testSetDefaultHyperparameters() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpPost("/api/analyses/" + this.analysisId + "/hyperParams/defaults", null);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=3, description="Set default values to hyperparameters for an unknown algorithm")
    public void testSetDefaultHyperparametersForAnUnknownAlgo() throws MLHttpClientException, IOException {
        HashMap<String, String> configurations = new HashMap<String, String>();
        configurations.put("algorithmName", "ABC");
        configurations.put("algorithmType", "Classification");
        configurations.put("responseVariable", "Class");
        configurations.put("trainDataFraction", "0.7");
        CloseableHttpResponse response = this.mlHttpclient.setModelConfiguration(this.analysisId2, configurations);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response = this.mlHttpclient.doHttpPost("/api/analyses/" + this.analysisId2 + "/hyperParams/defaults", null);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=3, description="Set default values to hyperparameters without setting model configs.")
    public void testSetDefaultHyperparametersWithoutModelConfigs() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpPost("/api/analyses/" + this.analysisId2 + "/hyperParams/defaults", null);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=3, description="Set customized hyperparameters", dependsOnMethods={"testSetDefaultHyperparameters"})
    public void testSetCustomizedHyperParameters() throws IOException, MLHttpClientException {
        String payload = "[{\"key\" :\"Learning_Rate\",\"value\" : \"0.1\"},{\"key\":\"Iterations\",\"value\":\"100\"}]";
        CloseableHttpResponse response = this.mlHttpclient.doHttpPost("/api/analyses/" + this.analysisId + "/hyperParams", payload);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=4, description="Get hyper parameters of the analyses")
    public void testGetHyperParameters() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/analyses/" + this.analysisId + "/hyperParameters");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=4, description="Get hyper parameters of the analyses and of a algorithm")
    public void testGetHyperParametersOfAlgorithm() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/analyses/" + this.analysisId + "/hyperParameters?algorithmName=" + "LOGISTIC_REGRESSION");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws MLHttpClientException {
        super.destroy();
    }
}

