/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.configs.test;

import java.io.IOException;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.json.JSONException;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.ml.MLTestUtils;
import org.wso2.carbon.ml.integration.common.utils.MLBaseTest;
import org.wso2.carbon.ml.integration.common.utils.MLHttpClient;
import org.wso2.carbon.ml.integration.common.utils.exception.MLHttpClientException;

@Test(groups={"getConfigs"})
public class ConfigurationAPITestCase
extends MLBaseTest {
    private MLHttpClient mlHttpclient;
    private static final Log log = LogFactory.getLog(ConfigurationAPITestCase.class);

    @BeforeClass(alwaysRun=true)
    public void initTest() throws Exception {
        super.init();
        this.mlHttpclient = this.getMLHttpClient();
    }

    @Test(description="Get all algorithms")
    public void testGetAllAlgorithmsConfig() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/configs/algorithms");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(description="Retrieve an algorithm")
    public void testGetAlgorithmConfig() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/configs/algorithms/LOGISTIC_REGRESSION");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(description="Retrieve hyper params of an algorithm")
    public void testGetHyperParamsOfAlgorithm() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/configs/algorithms/LOGISTIC_REGRESSION/hyperParams");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(description="Retrieve a non-existing algorithm")
    public void testGetNonExistingAnalysis() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/configs/algorithms/nonExistinfAlgo");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.NOT_FOUND.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(description="Get all das tables")
    public void testGetAllDASTables() throws MLHttpClientException, IOException, JSONException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/configs/das/tables");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        AssertJUnit.assertEquals((String)"DAS tables are not populated properly.", (boolean)true, (boolean)MLTestUtils.getJsonArrayAsString(response).contains("STREAMING_DATA"));
        response.close();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws MLHttpClientException {
        super.destroy();
    }
}

