/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.dataset.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.ml.integration.common.utils.MLBaseTest;
import org.wso2.carbon.ml.integration.common.utils.MLHttpClient;
import org.wso2.carbon.ml.integration.common.utils.exception.MLHttpClientException;

@Test(groups={"getDatasets"}, dependsOnGroups={"createDatasets"})
public class GetDatasetsTestCase
extends MLBaseTest {
    private MLHttpClient mlHttpclient;

    @BeforeClass(alwaysRun=true)
    public void initTest() throws Exception {
        super.init();
        this.mlHttpclient = this.getMLHttpClient();
        this.isDatasetProcessed(1, 120000L, 1000);
    }

    @Test(description="Get a dataset with a known ID")
    public void testGetDataset() throws MLHttpClientException, IOException, JSONException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/datasets/1");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        JSONObject responseJson = new JSONObject(bufferedReader.readLine());
        AssertJUnit.assertEquals((String)"Incorrect dataset retrieved", (int)1, (int)responseJson.getInt("id"));
        bufferedReader.close();
        response.close();
    }

    @Test(description="scatter plot points for a dataset")
    public void testGetScatterPlotPointsOfLatestVersion() throws MLHttpClientException, IOException, JSONException {
        String payload = "{\"xAxisFeature\": \"Age\", \"yAxisFeature\": \"NumPregnancies\", \"groupByFeature\": \"Class\"}";
        CloseableHttpResponse response = this.mlHttpclient.doHttpPost("/api/datasets/1/scatter", payload);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        AssertJUnit.assertEquals((String)"Response is not a JSON Array", (boolean)true, (boolean)bufferedReader.readLine().startsWith("["));
        bufferedReader.close();
        response.close();
    }

    @Test(description="chart sample points for a dataset")
    public void testGetChartSamplePointsOfLatestVersion() throws MLHttpClientException, IOException, JSONException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/datasets/1/charts?features=Age,NumPregnancies");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        AssertJUnit.assertEquals((String)"Response is not a JSON Array", (boolean)true, (boolean)bufferedReader.readLine().startsWith("["));
        bufferedReader.close();
        response.close();
    }

    @Test(description="cluster points for a dataset")
    public void testGetClusterPoints() throws MLHttpClientException, IOException, JSONException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/datasets/1/cluster?features=Age,NumPregnancies&noOfClusters=2");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        AssertJUnit.assertEquals((String)"Response is not a JSON Array", (boolean)true, (boolean)bufferedReader.readLine().startsWith("["));
        bufferedReader.close();
        response.close();
    }

    @Test(description="Get a dataset with an invalid ID")
    public void testGetDatasetWithInvalidId() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/datasets/999");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.NOT_FOUND.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(description="Get all available datasets")
    public void testGetAllDatasets() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/datasets");
        Assert.assertEquals((String)"Unexpected response received", (long)Response.Status.OK.getStatusCode(), (long)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(description="Get all available dataset versions")
    public void testGetAllDatasetVersions() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/datasets/versions");
        Assert.assertEquals((String)"Unexpected response received", (long)Response.Status.OK.getStatusCode(), (long)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(description="Get all available versions of a dataset")
    public void testGetVersionSetsOfdataset() throws MLHttpClientException, IOException, JSONException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/datasets/1/versions");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        JSONArray responseJson = new JSONArray(bufferedReader.readLine());
        JSONObject datsetVersionJson = (JSONObject)responseJson.get(0);
        Assert.assertEquals((String)"Incorrect version sets retrieved", (long)1L, (long)datsetVersionJson.getInt("id"));
        response.close();
        bufferedReader.close();
    }

    @Test(description="Get dataset version from its ID", dependsOnMethods={"testGetVersionSetsOfdataset"})
    public void testGetVersionSet() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/datasets/versions/1");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(description="Get version set with a version", dependsOnMethods={"testGetVersionSetsOfdataset"})
    public void testGetVersionSetWithVersion() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/datasets/1/versions/1.0");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(description="Get chart sample points of a dataset version", dependsOnMethods={"testGetVersionSetsOfdataset"})
    public void testGetChartSamplePointsOfVersionSet() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/datasets/versions/1/charts");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(description="scatter plot points for a versionset")
    public void testGetScatterPlotPoints() throws MLHttpClientException, IOException, JSONException {
        String payload = "{\"xAxisFeature\": \"Age\", \"yAxisFeature\": \"NumPregnancies\", \"groupByFeature\": \"Class\"}";
        CloseableHttpResponse response = this.mlHttpclient.doHttpPost("/api/datasets/versions/1/scatter", payload);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        AssertJUnit.assertEquals((String)"Response is not a JSON Array", (boolean)true, (boolean)bufferedReader.readLine().startsWith("["));
        bufferedReader.close();
        response.close();
    }

    @Test(description="chart sample points for a versionset")
    public void testGetChartSamplePoints() throws MLHttpClientException, IOException, JSONException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/datasets/versions/1/charts?features=Age,NumPregnancies");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        AssertJUnit.assertEquals((String)"Response is not a JSON Array", (boolean)true, (boolean)bufferedReader.readLine().startsWith("["));
        bufferedReader.close();
        response.close();
    }

    @Test(description="Get dataset version with a non-existing ID")
    public void testGetVersionSetWithInvalidId() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/datasets/versions/999");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.NOT_FOUND.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(description="Get feature names")
    public void testGetFeatureNamesOfDataset() throws MLHttpClientException, IOException, JSONException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/datasets/1/filteredFeatures");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        String line = bufferedReader.readLine();
        JSONArray responseJson = new JSONArray(line);
        AssertJUnit.assertEquals((String)"Filter is expected to return none.", (boolean)true, (responseJson.length() == 0 ? 1 : 0) != 0);
        bufferedReader.close();
        response.close();
    }

    @Test(description="Get categorical feature names")
    public void testGetCategoricalFeatureNamesOfDataset() throws MLHttpClientException, IOException, JSONException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/datasets/1/filteredFeatures?featureType=CATEGORICAL");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        String x = bufferedReader.readLine();
        System.out.println("###" + x);
        JSONArray responseJson = new JSONArray(x);
        AssertJUnit.assertEquals((String)("Categorical feature names was not returned. #" + x), (boolean)true, (responseJson.length() != 0 ? 1 : 0) != 0);
        bufferedReader.close();
        response.close();
    }

    @Test(description="Get summary stats - with feature")
    public void testGetSummaryStatsWithFeature() throws MLHttpClientException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/datasets/1/stats?feature=Class");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws MLHttpClientException {
        super.destroy();
    }
}

