/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.lifecycle.test;

import java.io.IOException;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.ml.MLTestUtils;
import org.wso2.carbon.ml.integration.common.utils.MLBaseTest;
import org.wso2.carbon.ml.integration.common.utils.MLHttpClient;
import org.wso2.carbon.ml.integration.common.utils.exception.MLHttpClientException;
import org.wso2.carbon.ml.integration.common.utils.exception.MLIntegrationBaseTestException;

@Test(groups={"dummyRecommendationDatasetCollaborativeFiltering"})
public class Dataset11RecommendationTestCase
extends MLBaseTest {
    private static String modelName;
    private static int modelId;
    private MLHttpClient mlHttpclient;
    private CloseableHttpResponse response;
    private int versionSetId;
    private int projectId;

    @BeforeClass(alwaysRun=true)
    public void initTest() throws MLIntegrationBaseTestException, MLHttpClientException, IOException, JSONException {
        super.init();
        this.mlHttpclient = this.getMLHttpClient();
        String version = "1.0";
        int datasetId = this.createDataset("Recommendation", version, "artifacts/ML/data/dummyRecommendation.csv");
        this.versionSetId = this.getVersionSetId(datasetId, version);
        this.isDatasetProcessed(this.versionSetId, 120000L, 1000);
        this.projectId = this.createProject("Recommendation_Project", "Recommendation");
    }

    private void buildModelWithLearningAlgorithm(String algorithmName, String algorithmType) throws MLHttpClientException, IOException, JSONException, InterruptedException {
        if (algorithmName.equals("COLLABORATIVE_FILTERING")) {
            modelName = MLTestUtils.createModelWithConfigurations(algorithmName, algorithmType, "USER_ID", "PRODUCT_ID", "RATING", "explicit", "1.0", this.projectId, this.versionSetId, this.mlHttpclient);
        } else if (algorithmName.equals("COLLABORATIVE_FILTERING_IMPLICIT")) {
            modelName = MLTestUtils.createModelWithConfigurations(algorithmName, algorithmType, "USER_ID", "PRODUCT_ID", "2,3", "implicit", "1.0", this.projectId, this.versionSetId, this.mlHttpclient);
        }
        modelId = this.mlHttpclient.getModelId(modelName);
        this.response = this.mlHttpclient.doHttpPost("/api/models/" + modelId, null);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)this.response.getStatusLine().getStatusCode());
        this.response.close();
        boolean status = MLTestUtils.checkModelStatusCompleted(modelName, this.mlHttpclient, 120000L, 1000);
        AssertJUnit.assertEquals((String)"Model building did not complete successfully", (boolean)true, (boolean)status);
    }

    private void testGetUserRecommendation() throws MLHttpClientException, JSONException {
        this.response = this.mlHttpclient.doHttpGet("/api/models/" + modelId + "/user-recommendations?product-id=123&no-of-users=2");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)this.response.getStatusLine().getStatusCode());
        String reply = this.mlHttpclient.getResponseAsString(this.response);
        JSONArray recommendations = new JSONArray(reply);
        AssertJUnit.assertEquals((int)2, (int)recommendations.length());
    }

    private void testGetProductRecommendation() throws MLHttpClientException, JSONException {
        this.response = this.mlHttpclient.doHttpGet("/api/models/" + modelId + "/product-recommendations?user-id=1&no-of-products=3");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)this.response.getStatusLine().getStatusCode());
        String reply = this.mlHttpclient.getResponseAsString(this.response);
        JSONArray recommendations = new JSONArray(reply);
        AssertJUnit.assertEquals((int)3, (int)recommendations.length());
    }

    private void testGetProductRecommendationInvalidModelId() throws MLHttpClientException, JSONException {
        this.response = this.mlHttpclient.doHttpGet("/api/models/999/product-recommendations?user-id=1&no-of-products=3");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (int)this.response.getStatusLine().getStatusCode());
    }

    private void testGetUserRecommendationInvalidModelId() throws MLHttpClientException, JSONException {
        this.response = this.mlHttpclient.doHttpGet("/api/models/999/user-recommendations?product-id=123&no-of-users=2");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (int)this.response.getStatusLine().getStatusCode());
    }

    @Test(description="Build a Unlabeled collaborative filtering explicit model for recommendation dataset", groups={"createCollaborativeFilteringExplicitRecommendation"})
    public void testBuildCollaborativeFilteringExplicit() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.buildModelWithLearningAlgorithm("COLLABORATIVE_FILTERING", "Recommendation");
        this.testGetProductRecommendation();
        this.testGetUserRecommendation();
        this.testGetProductRecommendationInvalidModelId();
    }

    @Test(description="Build a Unlabeled collaborative filtering implicit model for recommendation dataset", groups={"createCollaborativeFilteringImplicitRecommendation"}, dependsOnGroups={"createCollaborativeFilteringExplicitRecommendation"})
    public void testBuildCollaborativeFilteringImplicit() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.buildModelWithLearningAlgorithm("COLLABORATIVE_FILTERING_IMPLICIT", "Recommendation");
        this.testGetProductRecommendation();
        this.testGetUserRecommendation();
        this.testGetUserRecommendationInvalidModelId();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws InterruptedException, MLHttpClientException {
        super.destroy();
    }
}

