/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.lifecycle.test;

import java.io.IOException;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.ml.MLTestUtils;
import org.wso2.carbon.ml.integration.common.utils.MLBaseTest;
import org.wso2.carbon.ml.integration.common.utils.MLHttpClient;
import org.wso2.carbon.ml.integration.common.utils.exception.MLHttpClientException;
import org.wso2.carbon.ml.integration.common.utils.exception.MLIntegrationBaseTestException;

@Test(groups={"breastCancerDataset"})
public class Dataset3BreastCancerTestCase
extends MLBaseTest {
    private MLHttpClient mlHttpclient;
    private static String modelName;
    private static int modelId;
    private CloseableHttpResponse response;
    private int versionSetId;
    private int projectId;

    @BeforeClass(alwaysRun=true)
    public void initTest() throws MLIntegrationBaseTestException, MLHttpClientException, IOException, JSONException {
        super.init();
        this.mlHttpclient = this.getMLHttpClient();
        String version = "1.0";
        int datasetId = this.createDataset("Breast_Cancer", version, "artifacts/ML/data/breastCancerWisconsin.csv");
        this.versionSetId = this.getVersionSetId(datasetId, version);
        this.isDatasetProcessed(this.versionSetId, 120000L, 1000);
        this.projectId = this.createProject("Breast_Cancer_Project", "Breast_Cancer");
    }

    private void testPredictBreastCancer() throws MLHttpClientException, JSONException {
        String payload = "[[1015425,3,1,1,1,2,2,3,1,1],[1033078,2,1,1,1,2,1,1,1,5]]";
        this.response = this.mlHttpclient.doHttpPost("/api/models/" + modelId + "/predict", payload);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)this.response.getStatusLine().getStatusCode());
        String reply = this.mlHttpclient.getResponseAsString(this.response);
        JSONArray predictions = new JSONArray(reply);
        AssertJUnit.assertEquals((int)2, (int)predictions.length());
    }

    private void buildModelWithLearningAlgorithm(String algorithmName, String algorithmType) throws MLHttpClientException, IOException, JSONException, InterruptedException {
        modelName = MLTestUtils.createModelWithConfigurations(algorithmName, algorithmType, "Class", "0.7", this.projectId, this.versionSetId, this.mlHttpclient);
        modelId = this.mlHttpclient.getModelId(modelName);
        this.response = this.mlHttpclient.doHttpPost("/api/models/" + modelId, null);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)this.response.getStatusLine().getStatusCode());
        this.response.close();
        boolean status = MLTestUtils.checkModelStatusCompleted(modelName, this.mlHttpclient, 120000L, 1000);
        AssertJUnit.assertEquals((String)"Model building did not complete successfully", (boolean)true, (boolean)status);
    }

    @Test(description="Build a Naive Bayes model and predict for breast cancer dataset", groups={"createNaiveBayesModelBreastCancer"})
    public void testBuildNaiveBayesModel() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.buildModelWithLearningAlgorithm("NAIVE_BAYES", "Classification");
        this.testPredictBreastCancer();
    }

    @Test(description="Build a SVM model and predict for breast cancer dataset", groups={"createSVMModelBreastCancer"}, dependsOnGroups={"createNaiveBayesModelBreastCancer"})
    public void testBuildSVMModel() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.buildModelWithLearningAlgorithm("SVM", "Classification");
        this.testPredictBreastCancer();
        this.testExportAsPMML(modelId);
        this.testPublishAsPMML(modelId);
    }

    @Test(description="Build a Decision Tree model and predict for breast cancer dataset", groups={"createDecisionTreeModelBreastCancer"}, dependsOnGroups={"createSVMModelBreastCancer"})
    public void testBuildDecisionTreeModel() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.buildModelWithLearningAlgorithm("DECISION_TREE", "Classification");
        this.testPredictBreastCancer();
    }

    @Test(description="Build a Logistic Regression model and predict for breast cancer dataset", groups={"createLogisticRegressionBreastCancer"}, dependsOnGroups={"createDecisionTreeModelBreastCancer"})
    public void testBuildLogisticRegressionModel() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.buildModelWithLearningAlgorithm("LOGISTIC_REGRESSION", "Classification");
        this.testPredictBreastCancer();
        this.testExportAsPMML(modelId);
        this.testPublishAsPMML(modelId);
    }

    @Test(description="Build a Stacked Autoencoders model and predict for breast cancer dataset", groups={"createStackedAutoencodersBreastCancer"}, dependsOnGroups={"createLogisticRegressionBreastCancer"})
    public void testBuildStackedAutoencodersModel() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.buildModelWithLearningAlgorithm("STACKED_AUTOENCODERS", "Deeplearning");
        this.testPredictBreastCancer();
    }

    @Test(description="Build a K-means model", groups={"createKMeansBreastCancer"}, dependsOnGroups={"createStackedAutoencodersBreastCancer"})
    public void testBuildKMeansModel() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.buildModelWithLearningAlgorithm("K_MEANS", "Clustering");
        this.testExportAsPMML(modelId);
        this.testPublishAsPMML(modelId);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws InterruptedException, MLHttpClientException {
        super.destroy();
    }
}

