/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.model.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.ml.MLTestUtils;
import org.wso2.carbon.ml.integration.common.utils.MLBaseTest;
import org.wso2.carbon.ml.integration.common.utils.MLHttpClient;
import org.wso2.carbon.ml.integration.common.utils.exception.MLHttpClientException;

@Test(groups={"getModels"})
public class PostModelCreationTestCase
extends MLBaseTest {
    private MLHttpClient mlHttpclient;
    private int projectId;
    private int analysisId;
    private int versionSetId;
    private int modelId;
    private String modelName;

    @BeforeClass(alwaysRun=true)
    public void initTest() throws Exception {
        super.init();
        this.mlHttpclient = this.getMLHttpClient();
        String version = "1.0";
        int datasetId = this.createDataset("Diabetes", version, "artifacts/ML/data/pIndiansDiabetes.csv");
        this.versionSetId = this.getVersionSetId(datasetId, version);
        this.isDatasetProcessed(this.versionSetId, 120000L, 1000);
        this.projectId = this.createProject("Diabetes_Project", "Diabetes");
        this.analysisId = this.createAnalysis("Dummy_Analysis", this.projectId);
        this.buildModelWithLearningAlgorithm("LOGISTIC_REGRESSION", "Classification");
    }

    @Test(priority=1, description="retrieve a model")
    public void testGetModel() throws MLHttpClientException, IOException, JSONException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/models/" + this.modelName);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        JSONObject responseJson = new JSONObject(bufferedReader.readLine());
        bufferedReader.close();
        response.close();
        AssertJUnit.assertEquals((String)"Incorrect model retrieved.", (int)this.modelId, (int)responseJson.getInt("id"));
    }

    @Test(priority=1, description="retrieve models of a project")
    public void testGetCompletedModelsOfProject() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/projects/" + this.projectId + "/models");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        String line = bufferedReader.readLine();
        JSONArray responseJson = new JSONArray(line);
        JSONObject modelJson = (JSONObject)responseJson.get(0);
        bufferedReader.close();
        response.close();
        AssertJUnit.assertEquals((String)"Incorrect model retrieved.", (int)this.modelId, (int)modelJson.getInt("id"));
    }

    @Test(priority=1, description="retrieve models of an analysis")
    public void testGetModelsOfAnalysis() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/analyses/" + this.analysisId + "/models");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        String line = bufferedReader.readLine();
        JSONArray responseJson = new JSONArray(line);
        JSONObject modelJson = (JSONObject)responseJson.get(0);
        bufferedReader.close();
        response.close();
        AssertJUnit.assertEquals((String)"Incorrect model retrieved.", (int)this.modelId, (int)modelJson.getInt("id"));
    }

    @Test(priority=1, description="retrieve all models")
    public void testGetAllModels() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/models/");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        String line = bufferedReader.readLine();
        JSONArray responseJson = new JSONArray(line);
        JSONObject modelJson = (JSONObject)responseJson.get(0);
        bufferedReader.close();
        response.close();
        AssertJUnit.assertEquals((String)"Incorrect model retrieved.", (int)this.modelId, (int)modelJson.getInt("id"));
    }

    @Test(priority=2, description="retrieve model summary")
    public void testGetModelSummary() throws MLHttpClientException, IOException, JSONException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/models/" + this.modelId + "/summary");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=3, description="Publish a Model")
    public void testPublishModel() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpPost("/api/models/" + this.modelId + "/publish", null);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=3, description="Publish a non-existing Model")
    public void testPublishNonExistingModel() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpPost("/api/models/999/publish", null);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.NOT_FOUND.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=3, description="Build a non-existing Model")
    public void testBuildModelWithInvalidId() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpPost("/api/models/999", null);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=10, description="Delete a model")
    public void testDeleteModel() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpDelete("/api/models/" + this.modelId);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    private void buildModelWithLearningAlgorithm(String algorithmName, String algorithmType) throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.modelName = MLTestUtils.createModelWithConfigurations(algorithmName, algorithmType, "Class", "0.7", this.projectId, this.versionSetId, this.analysisId, this.mlHttpclient);
        this.modelId = this.mlHttpclient.getModelId(this.modelName);
        CloseableHttpResponse response = this.mlHttpclient.doHttpPost("/api/models/" + this.modelId, null);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
        boolean status = MLTestUtils.checkModelStatusCompleted(this.modelName, this.mlHttpclient, 120000L, 1000);
        AssertJUnit.assertEquals((String)"Model building did not complete successfully", (boolean)true, (boolean)status);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws MLHttpClientException {
        super.destroy();
    }
}

