/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.lifecycle.test;

import java.io.IOException;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.ml.MLTestUtils;
import org.wso2.carbon.ml.integration.common.utils.MLBaseTest;
import org.wso2.carbon.ml.integration.common.utils.MLHttpClient;
import org.wso2.carbon.ml.integration.common.utils.exception.MLHttpClientException;
import org.wso2.carbon.ml.integration.common.utils.exception.MLIntegrationBaseTestException;

@Test(groups={"dasDataset"})
public class Dataset8DASDataTestCase
extends MLBaseTest {
    private MLHttpClient mlHttpclient;
    private static String modelName;
    private static int modelId;
    private CloseableHttpResponse response;
    private int versionSetId;
    private int projectId;

    @BeforeClass(alwaysRun=true)
    public void initTest() throws MLIntegrationBaseTestException, MLHttpClientException, IOException, JSONException {
        super.init();
        this.mlHttpclient = this.getMLHttpClient();
        String version = "1.0";
        int datasetId = this.createDatasetFromDASTable("das_data", version, "STREAMING_DATA");
        this.versionSetId = this.getVersionSetId(datasetId, version);
        this.isDatasetProcessed(this.versionSetId, 120000L, 1000);
        this.projectId = this.createProject("DAS_Project", "das_data");
    }

    private void buildModelWithLearningAlgorithm(String algorithmName, String algorithmType) throws MLHttpClientException, IOException, JSONException, InterruptedException {
        modelName = MLTestUtils.createModelWithConfigurations(algorithmName, algorithmType, "value", "0.7", this.projectId, this.versionSetId, this.mlHttpclient);
        String payload = "[{\"name\" : \"id\",\"tenantId\" : -1234,\"type\" : \"NUMERICAL\",\"include\" : false,\"imputeOption\": \"DISCARD\"}, {\"name\" : \"meta_type\",\"tenantId\" : -1234,\"type\" : \"NUMERICAL\",\"include\" : false,\"imputeOption\": \"DISCARD\"}, {\"name\" : \"property\",\"tenantId\" : -1234,\"type\" : \"NUMERICAL\",\"include\" : false,\"imputeOption\": \"DISCARD\"}, {\"name\" : \"timeStamp\",\"tenantId\" : -1234,\"type\" : \"NUMERICAL\",\"include\" : false,\"imputeOption\": \"DISCARD\"}]";
        int analysisId = this.mlHttpclient.getAnalysisId(this.projectId, algorithmName + this.versionSetId);
        this.mlHttpclient.setFeatureCustomized(analysisId, payload);
        modelId = this.mlHttpclient.getModelId(modelName);
        this.response = this.mlHttpclient.doHttpPost("/api/models/" + modelId, null);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)this.response.getStatusLine().getStatusCode());
        this.response.close();
        boolean status = MLTestUtils.checkModelStatusCompleted(modelName, this.mlHttpclient, 120000L, 1000);
        AssertJUnit.assertEquals((String)"Model building did not complete successfully", (boolean)true, (boolean)status);
    }

    @Test(description="Build a linear regression model and predict for DAS dataset", groups={"createLinearRegressionModelDAS"})
    public void testBuildLinearRegressionModel() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.buildModelWithLearningAlgorithm("LINEAR_REGRESSION", "Numerical_Prediction");
        this.testPredictDAS();
        this.testExportAsPMML(modelId);
        this.testPublishAsPMML(modelId);
    }

    private void testPredictDAS() throws MLHttpClientException, JSONException {
        String payload = "[[21,3,2],[211,1,7]]";
        this.response = this.mlHttpclient.doHttpPost("/api/models/" + modelId + "/predict", payload);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)this.response.getStatusLine().getStatusCode());
        String reply = this.mlHttpclient.getResponseAsString(this.response);
        JSONArray predictions = new JSONArray(reply);
        AssertJUnit.assertEquals((int)2, (int)predictions.length());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws InterruptedException, MLHttpClientException {
        super.destroy();
    }
}

