/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.lifecycle.test;

import java.io.IOException;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.ml.MLTestUtils;
import org.wso2.carbon.ml.integration.common.utils.MLBaseTest;
import org.wso2.carbon.ml.integration.common.utils.MLHttpClient;
import org.wso2.carbon.ml.integration.common.utils.exception.MLHttpClientException;
import org.wso2.carbon.ml.integration.common.utils.exception.MLIntegrationBaseTestException;

@Test(groups={"abaloneDataset"})
public class Dataset9AbaloneTestCase
extends MLBaseTest {
    private MLHttpClient mlHttpclient;
    private static String modelName;
    private static int modelId;
    private CloseableHttpResponse response;
    private int versionSetId;
    private int projectId;

    @BeforeClass(alwaysRun=true)
    public void initTest() throws MLIntegrationBaseTestException, MLHttpClientException, IOException, JSONException {
        super.init();
        this.mlHttpclient = this.getMLHttpClient();
        String version = "1.0";
        int datasetId = this.createDataset("Abalone", version, "artifacts/ML/data/abalone.csv");
        this.versionSetId = this.getVersionSetId(datasetId, version);
        this.isDatasetProcessed(this.versionSetId, 120000L, 1000);
        this.projectId = this.createProject("Abalone_Project", "Abalone");
    }

    private void testPredictAbalone() throws MLHttpClientException, JSONException {
        String payload = "[[0.455,0.365,0.095,0.514,0.2245,0.101,0.15,15],[0.44,0.365,0.125,0.516,0.2155,0.114,0.155,10]]";
        this.response = this.mlHttpclient.doHttpPost("/api/models/" + modelId + "/predict", payload);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)this.response.getStatusLine().getStatusCode());
        String reply = this.mlHttpclient.getResponseAsString(this.response);
        JSONArray predictions = new JSONArray(reply);
        AssertJUnit.assertEquals((int)2, (int)predictions.length());
    }

    private boolean buildModelWithLearningAlgorithm(String algorithmName, String algorithmType) throws MLHttpClientException, IOException, JSONException, InterruptedException {
        modelName = MLTestUtils.createModelWithConfigurations(algorithmName, algorithmType, "Sex", "0.7", this.projectId, this.versionSetId, this.mlHttpclient);
        modelId = this.mlHttpclient.getModelId(modelName);
        this.response = this.mlHttpclient.doHttpPost("/api/models/" + modelId, null);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)this.response.getStatusLine().getStatusCode());
        this.response.close();
        boolean status = MLTestUtils.checkModelStatusCompleted(modelName, this.mlHttpclient, 120000L, 1000);
        return status;
    }

    private boolean buildModelWithLearningAlgorithmExpectingFailure(String algorithmName, String algorithmType) throws MLHttpClientException, IOException, JSONException, InterruptedException {
        modelName = MLTestUtils.createModelWithConfigurations(algorithmName, algorithmType, "Sex", "0.7", this.projectId, this.versionSetId, this.mlHttpclient);
        modelId = this.mlHttpclient.getModelId(modelName);
        this.response = this.mlHttpclient.doHttpPost("/api/models/" + modelId, null);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)this.response.getStatusLine().getStatusCode());
        this.response.close();
        boolean status = MLTestUtils.checkModelStatusFailed(modelName, this.mlHttpclient, 120000L, 1000);
        return status;
    }

    @Test(description="Build a Naive Bayes model and predict for abalone dataset", groups={"createNaiveBayesModelAbalone"})
    public void testBuildNaiveBayesModel() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.buildModelWithLearningAlgorithm("NAIVE_BAYES", "Classification");
        this.testPredictAbalone();
    }

    @Test(description="Build a Random Forest model and predict for abalone dataset", groups={"createRandomForestModelAbalone"})
    public void testBuildRandomForest() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.buildModelWithLearningAlgorithm("RANDOM_FOREST", "Classification");
        this.testPredictAbalone();
    }

    @Test(description="Build a Logistic Regression LBFGS model and predict for abalone dataset", groups={"createLogisticRegressionModelLBFGSAbalone"})
    public void testBuildLogisticRegressionLBFGSModel() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.buildModelWithLearningAlgorithm("LOGISTIC_REGRESSION_LBFGS", "Classification");
        this.testPredictAbalone();
    }

    @Test(description="Build a SVM model for abalone dataset", groups={"createSVMModelAbalone"})
    public void testBuildSVMModel() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        boolean status = this.buildModelWithLearningAlgorithmExpectingFailure("SVM", "Classification");
        AssertJUnit.assertEquals((String)"Model building did not fail as expected.", (boolean)true, (boolean)status);
        this.testExportAsPMML();
        this.testPublishAsPMML();
    }

    @Test(description="Build a Logistic Regression model for abalone dataset", groups={"createLogisticRegressionAbalone"})
    public void testBuildLogisticRegressionModel() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        boolean status = this.buildModelWithLearningAlgorithmExpectingFailure("LOGISTIC_REGRESSION", "Classification");
        AssertJUnit.assertEquals((String)"Model building did not fail as expected.", (boolean)true, (boolean)status);
        this.testExportAsPMML();
        this.testPublishAsPMML();
    }

    @Test(description="Build a Linear Regression model for abalone dataset", groups={"createLinearRegressionAbalone"})
    public void testBuildLinearRegressionModel() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        boolean status = this.buildModelWithLearningAlgorithmExpectingFailure("LINEAR_REGRESSION", "Numerical_Prediction");
        AssertJUnit.assertEquals((String)"Model building did not fail as expected.", (boolean)true, (boolean)status);
        this.testExportAsPMML();
        this.testPublishAsPMML();
    }

    private void testExportAsPMML() throws MLHttpClientException {
        this.response = this.mlHttpclient.exportAsPMML(modelId);
        AssertJUnit.assertEquals((String)"PMML download did not fail as expected", (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (int)this.response.getStatusLine().getStatusCode());
    }

    private void testPublishAsPMML() throws MLHttpClientException {
        this.response = this.mlHttpclient.doHttpPost("/api/models/" + modelId + "/publish?mode=pmml", null);
        AssertJUnit.assertEquals((String)"Pmml publish did not fail as expected", (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (int)this.response.getStatusLine().getStatusCode());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws InterruptedException, MLHttpClientException {
        super.destroy();
    }
}

