/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.model.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.ml.MLTestUtils;
import org.wso2.carbon.ml.integration.common.utils.MLBaseTest;
import org.wso2.carbon.ml.integration.common.utils.MLHttpClient;
import org.wso2.carbon.ml.integration.common.utils.exception.MLHttpClientException;

@Test(groups={"failing-models"})
public class FailingModelTestCase
extends MLBaseTest {
    private MLHttpClient mlHttpclient;
    private int projectId;
    private int analysisId;
    private int versionSetId;
    private int modelId;
    private String modelName;

    @BeforeClass(alwaysRun=true)
    public void initTest() throws Exception {
        super.init();
        this.mlHttpclient = this.getMLHttpClient();
        String version = "1.0";
        int datasetId = this.createDataset("Automobile", version, "artifacts/ML/data/automobile.csv");
        this.versionSetId = this.getVersionSetId(datasetId, version);
        this.isDatasetProcessed(this.versionSetId, 120000L, 1000);
        this.projectId = this.createProject("Automobile_Project", "Automobile");
        this.analysisId = this.createAnalysis("Dummy_Analysis", this.projectId);
        this.buildModelWithLearningAlgorithm("LOGISTIC_REGRESSION", "Classification");
    }

    @Test(priority=1, description="retrieve a failed model")
    public void testGetFailedModel() throws MLHttpClientException, IOException, JSONException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/models/" + this.modelName);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        JSONObject responseJson = new JSONObject(bufferedReader.readLine());
        bufferedReader.close();
        response.close();
        AssertJUnit.assertEquals((String)"Incorrect model retrieved.", (int)this.modelId, (int)responseJson.getInt("id"));
        AssertJUnit.assertEquals((String)"Model error has not been set.", (boolean)true, (responseJson.getString("error") != null ? 1 : 0) != 0);
    }

    private void buildModelWithLearningAlgorithm(String algorithmName, String algorithmType) throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.modelName = MLTestUtils.createModelWithConfigurations(algorithmName, algorithmType, "Class", "0.7", this.projectId, this.versionSetId, this.analysisId, this.mlHttpclient);
        this.modelId = this.mlHttpclient.getModelId(this.modelName);
        CloseableHttpResponse response = this.mlHttpclient.doHttpPost("/api/models/" + this.modelId, null);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
        boolean status = MLTestUtils.checkModelStatusFailed(this.modelName, this.mlHttpclient, 120000L, 1000);
        AssertJUnit.assertEquals((String)"Model building did not fail.", (boolean)true, (boolean)status);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws MLHttpClientException {
        super.destroy();
    }
}

