/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.configprovider;

import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.annotations.Configuration;
import org.wso2.carbon.kernel.configprovider.CarbonConfigurationException;
import org.wso2.carbon.kernel.configprovider.ConfigFileReader;
import org.wso2.carbon.kernel.configprovider.ConfigProvider;
import org.wso2.carbon.kernel.internal.configprovider.ConfigProviderDataHolder;
import org.wso2.carbon.kernel.securevault.exception.SecureVaultException;
import org.wso2.carbon.kernel.utils.Utils;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.introspector.BeanAccess;

public class ConfigProviderImpl
implements ConfigProvider {
    private static final Logger logger = LoggerFactory.getLogger(ConfigProviderImpl.class.getName());
    private static volatile Map<String, String> deploymentConfigs = null;
    private static final String PLACEHOLDER_REGEX = "(.*?)(\\$\\{(" + ConfigProviderImpl.getPlaceholderString() + "):([^,]+?)((,)(.+?))?\\})(.*?)";
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile(PLACEHOLDER_REGEX);
    private ConfigFileReader configFileReader;

    public ConfigProviderImpl(ConfigFileReader configFileReader) {
        this.configFileReader = configFileReader;
    }

    @Override
    public <T> T getConfigurationObject(Class<T> configClass) throws CarbonConfigurationException {
        Configuration configuration;
        String namespace = null;
        if (configClass.isAnnotationPresent(Configuration.class) && !"NULL".equals((configuration = configClass.getAnnotation(Configuration.class)).namespace())) {
            namespace = configuration.namespace();
        }
        this.loadDeploymentConfiguration(this.configFileReader);
        if (namespace != null && deploymentConfigs.containsKey(namespace)) {
            String yamlConfigString = deploymentConfigs.get(namespace);
            if (logger.isDebugEnabled()) {
                logger.debug("class name: " + configClass.getSimpleName() + " | new configurations: \n" + yamlConfigString);
            }
            String yamlProcessedString = this.processPlaceholder(yamlConfigString);
            yamlProcessedString = Utils.substituteVariables(yamlProcessedString);
            Yaml yaml = new Yaml(new CustomClassLoaderConstructor(configClass, configClass.getClassLoader()));
            yaml.setBeanAccess(BeanAccess.FIELD);
            return yaml.loadAs(yamlProcessedString, configClass);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Deployment configuration mapping doesn't exist: creating configuration instance with default values");
        }
        try {
            return configClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CarbonConfigurationException("Error while creating configuration instance: " + configClass.getSimpleName(), e);
        }
    }

    @Override
    public Map getConfigurationMap(String namespace) throws CarbonConfigurationException {
        this.loadDeploymentConfiguration(this.configFileReader);
        if (deploymentConfigs.containsKey(namespace)) {
            String configString = deploymentConfigs.get(namespace);
            String processedString = this.processPlaceholder(configString);
            processedString = Utils.substituteVariables(processedString);
            Yaml yaml = new Yaml();
            return yaml.loadAs(processedString, Map.class);
        }
        logger.error("configuration doesn't exist for the namespace: " + namespace + " in deployment yaml. Hence " + "return null object");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDeploymentConfiguration(ConfigFileReader configFileReader) throws CarbonConfigurationException {
        if (deploymentConfigs == null) {
            ConfigProviderImpl configProviderImpl = this;
            synchronized (configProviderImpl) {
                if (deploymentConfigs == null) {
                    deploymentConfigs = configFileReader.getDeploymentConfiguration();
                }
            }
        }
    }

    private static String getPlaceholderString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Placeholder placeholder : Placeholder.values()) {
            stringBuilder.append(placeholder.getValue()).append("|");
        }
        String value = stringBuilder.substring(0, stringBuilder.length() - 1);
        logger.debug("PlaceHolders String: {}", (Object)value);
        return value;
    }

    private String processPlaceholder(String inputString) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(inputString);
        while (matcher.find()) {
            String key = matcher.group(3);
            String value = matcher.group(4);
            String defaultValue = matcher.group(7);
            switch (key) {
                case "env": {
                    inputString = ConfigProviderImpl.processValue(System::getenv, value, inputString, defaultValue, Placeholder.ENV);
                    break;
                }
                case "sys": {
                    inputString = ConfigProviderImpl.processValue(System::getProperty, value, inputString, defaultValue, Placeholder.SYS);
                    break;
                }
                case "sec": {
                    try {
                        if (ConfigProviderDataHolder.getInstance().getSecureVault() == null) {
                            throw new RuntimeException("Secure Vault service is not available");
                        }
                        String newValue = new String(ConfigProviderDataHolder.getInstance().getSecureVault().resolve(value));
                        inputString = inputString.replaceFirst(PLACEHOLDER_REGEX, "$1" + newValue + "$8");
                        break;
                    }
                    catch (SecureVaultException e) {
                        throw new RuntimeException("Unable to resolve the given alias", e);
                    }
                }
                default: {
                    String msg = String.format("Unsupported placeholder: %s", key);
                    logger.error(msg);
                    throw new RuntimeException(msg);
                }
            }
        }
        return inputString;
    }

    private static String processValue(Function<String, String> func, String key, String inputString, String defaultValue, Placeholder type) {
        String newValue = func.apply(key);
        if (newValue != null) {
            return inputString.replaceFirst(PLACEHOLDER_REGEX, "$1" + newValue + "$8");
        }
        if (defaultValue != null) {
            return inputString.replaceFirst(PLACEHOLDER_REGEX, "$1" + defaultValue + "$8");
        }
        String msg = Placeholder.ENV.getValue().equals(type.getValue()) ? String.format("Environment variable %s not found. Placeholder: %s", key, inputString) : (Placeholder.SYS.getValue().equals(type.getValue()) ? String.format("System property %s not found. Placeholder: %s", key, inputString) : String.format("Unsupported placeholder type: %s", type.getValue()));
        logger.error(msg);
        throw new RuntimeException(msg);
    }

    private static enum Placeholder {
        SYS("sys"),
        ENV("env"),
        SEC("sec");

        private String value;

        private Placeholder(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

