/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.securevault.repository;

import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.securevault.SecretRepository;
import org.wso2.carbon.kernel.securevault.SecureVaultUtils;
import org.wso2.carbon.kernel.securevault.config.model.SecretRepositoryConfiguration;
import org.wso2.carbon.kernel.securevault.exception.SecureVaultException;

public abstract class AbstractSecretRepository
implements SecretRepository {
    private static Logger logger = LoggerFactory.getLogger(AbstractSecretRepository.class);
    private final Map<String, char[]> secrets = new HashMap<String, char[]>();

    @Override
    public void loadSecrets(SecretRepositoryConfiguration secretRepositoryConfiguration) throws SecureVaultException {
        logger.debug("Loading secrets to SecretRepository");
        Path secretPropertiesFilePath = Paths.get(SecureVaultUtils.getSecretPropertiesFileLocation(secretRepositoryConfiguration), new String[0]);
        String resolvedFileContent = SecureVaultUtils.resolveFileToString(secretPropertiesFilePath.toFile());
        Properties secretsProperties = new Properties();
        try {
            secretsProperties.load(new StringReader(resolvedFileContent));
        }
        catch (IOException e) {
            throw new SecureVaultException("Failed to load secrets.properties file");
        }
        for (Map.Entry<Object, Object> entry : secretsProperties.entrySet()) {
            char[] decryptedPassword;
            String key = entry.getKey().toString().trim();
            String value = entry.getValue().toString().trim();
            String[] tokens = value.split(" ");
            if (tokens.length != 2) {
                logger.error("Secret properties file contains an invalid entry at key : {}", (Object)key);
                continue;
            }
            String updatedTokenValue = SecureVaultUtils.substituteVariables(tokens[1]);
            if ("cipherText".equals(tokens[0])) {
                byte[] base64Decoded = SecureVaultUtils.base64Decode(SecureVaultUtils.toBytes(updatedTokenValue));
                decryptedPassword = SecureVaultUtils.toChars(this.decrypt(base64Decoded));
            } else if ("plainText".equals(tokens[0])) {
                decryptedPassword = updatedTokenValue.toCharArray();
            } else {
                logger.error("Unknown prefix in secrets file");
                continue;
            }
            this.secrets.put(key, decryptedPassword);
        }
        logger.debug("Secret repository loaded with '{}' secrets", (Object)this.secrets.size());
    }

    @Override
    public void persistSecrets(SecretRepositoryConfiguration secretRepositoryConfiguration) throws SecureVaultException {
        logger.debug("Persisting secrets to SecretRepository");
        Path secretPropertiesFilePath = Paths.get(SecureVaultUtils.getSecretPropertiesFileLocation(secretRepositoryConfiguration), new String[0]);
        Properties secretsProperties = SecureVaultUtils.loadSecretFile(secretPropertiesFilePath);
        int count = 0;
        for (Map.Entry<Object, Object> entry : secretsProperties.entrySet()) {
            String key = entry.getKey().toString().trim();
            String value = entry.getValue().toString().trim();
            String[] tokens = value.split(" ");
            if (tokens.length != 2) {
                logger.error("Secret properties file contains an invalid entry at key : {}", (Object)key);
                continue;
            }
            if (!"plainText".equals(tokens[0])) continue;
            byte[] encryptedPassword = SecureVaultUtils.base64Encode(this.encrypt(SecureVaultUtils.toBytes(tokens[1].trim())));
            secretsProperties.setProperty(key, "cipherText " + new String(SecureVaultUtils.toChars(encryptedPassword)));
            ++count;
        }
        SecureVaultUtils.updateSecretFile(secretPropertiesFilePath, secretsProperties);
        logger.debug("Secrets file updated with '{}' new encrypted secrets", (Object)count);
    }

    @Override
    public char[] resolve(String alias) {
        char[] secret = this.secrets.get(alias);
        if (secret != null && secret.length != 0) {
            return secret;
        }
        return new char[0];
    }
}

