/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.config;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.config.SenderConfiguration;
import org.wso2.carbon.transport.http.netty.config.TransportProperty;

@XmlRootElement(name="transports")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TransportsConfiguration {
    @XmlElementWrapper(name="properties")
    @XmlElement(name="property")
    private Set<TransportProperty> transportProperties = Collections.EMPTY_SET;
    @XmlElementWrapper(name="listeners")
    @XmlElement(name="listener")
    private Set<ListenerConfiguration> listenerConfigurations;
    @XmlElementWrapper(name="senders")
    @XmlElement(name="sender")
    private Set<SenderConfiguration> senderConfigurations;

    public static TransportsConfiguration getDefault() {
        TransportsConfiguration defaultConfig = new TransportsConfiguration();
        ListenerConfiguration listenerConfiguration = ListenerConfiguration.getDefault();
        HashSet<ListenerConfiguration> listenerConfigurations = new HashSet<ListenerConfiguration>();
        listenerConfigurations.add(listenerConfiguration);
        defaultConfig.setListenerConfigurations(listenerConfigurations);
        SenderConfiguration senderConfiguration = SenderConfiguration.getDefault();
        HashSet<SenderConfiguration> senderConfigurations = new HashSet<SenderConfiguration>();
        senderConfigurations.add(senderConfiguration);
        defaultConfig.setSenderConfigurations(senderConfigurations);
        HashSet<TransportProperty> transportProperties = new HashSet<TransportProperty>();
        defaultConfig.setTransportProperties(transportProperties);
        return defaultConfig;
    }

    public Set<ListenerConfiguration> getListenerConfigurations() {
        if (this.listenerConfigurations == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.listenerConfigurations);
    }

    public Set<SenderConfiguration> getSenderConfigurations() {
        if (this.senderConfigurations == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.senderConfigurations);
    }

    public void setListenerConfigurations(Set<ListenerConfiguration> listenerConfigurations) {
        this.listenerConfigurations = Collections.unmodifiableSet(listenerConfigurations);
    }

    public void setSenderConfigurations(Set<SenderConfiguration> senderConfigurations) {
        this.senderConfigurations = Collections.unmodifiableSet(senderConfigurations);
    }

    public Set<TransportProperty> getTransportProperties() {
        return this.transportProperties;
    }

    public void setTransportProperties(Set<TransportProperty> transportProperties) {
        this.transportProperties = transportProperties;
    }
}

