/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.common;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.Constants;
import org.wso2.transport.http.netty.common.ssl.SSLConfig;
import org.wso2.transport.http.netty.config.ChunkConfig;
import org.wso2.transport.http.netty.config.Parameter;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class Util {
    private static Logger log = LoggerFactory.getLogger(Util.class);
    private static final Pattern varPattern = Pattern.compile("\\$\\{([^}]*)}");

    private static String getStringValue(HTTPCarbonMessage msg, String key, String defaultValue) {
        String value = (String)msg.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private static int getIntValue(HTTPCarbonMessage msg, String key, int defaultValue) {
        Integer value = (Integer)msg.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static HttpResponse createHttpResponse(HTTPCarbonMessage outboundResponseMsg, String inboundReqHttpVersion, String serverName, boolean keepAlive) {
        HttpVersion httpVersion = new HttpVersion("HTTP/" + inboundReqHttpVersion, true);
        HttpResponseStatus httpResponseStatus = Util.getHttpResponseStatus(outboundResponseMsg);
        DefaultHttpResponse outboundNettyResponse = new DefaultHttpResponse(httpVersion, httpResponseStatus, false);
        Util.setOutboundRespHeaders(outboundResponseMsg, inboundReqHttpVersion, serverName, keepAlive, outboundNettyResponse);
        return outboundNettyResponse;
    }

    public static HttpResponse createFullHttpResponse(HTTPCarbonMessage outboundResponseMsg, String inboundReqHttpVersion, String serverName, boolean keepAlive, ByteBuf fullContent) {
        HttpVersion httpVersion = new HttpVersion("HTTP/" + inboundReqHttpVersion, true);
        HttpResponseStatus httpResponseStatus = Util.getHttpResponseStatus(outboundResponseMsg);
        DefaultFullHttpResponse outboundNettyResponse = new DefaultFullHttpResponse(httpVersion, httpResponseStatus, fullContent, false);
        Util.setOutboundRespHeaders(outboundResponseMsg, inboundReqHttpVersion, serverName, keepAlive, outboundNettyResponse);
        return outboundNettyResponse;
    }

    private static void setOutboundRespHeaders(HTTPCarbonMessage outboundResponseMsg, String inboundReqHttpVersion, String serverName, boolean keepAlive, HttpResponse outboundNettyResponse) {
        if (!keepAlive && Float.valueOf(inboundReqHttpVersion).floatValue() >= 1.1f) {
            outboundResponseMsg.setHeader(HttpHeaderNames.CONNECTION.toString(), "close");
        } else if (keepAlive && Float.valueOf(inboundReqHttpVersion).floatValue() < 1.1f) {
            outboundResponseMsg.setHeader(HttpHeaderNames.CONNECTION.toString(), "keep-alive");
        } else {
            outboundResponseMsg.removeHeader(HttpHeaderNames.CONNECTION.toString());
        }
        if (outboundResponseMsg.getHeader(HttpHeaderNames.SERVER.toString()) == null) {
            outboundResponseMsg.setHeader(HttpHeaderNames.SERVER.toString(), serverName);
        }
        if (outboundResponseMsg.getHeader(HttpHeaderNames.DATE.toString()) == null) {
            outboundResponseMsg.setHeader(HttpHeaderNames.DATE.toString(), ZonedDateTime.now().format(DateTimeFormatter.RFC_1123_DATE_TIME));
        }
        outboundNettyResponse.headers().add(outboundResponseMsg.getHeaders());
    }

    private static HttpResponseStatus getHttpResponseStatus(HTTPCarbonMessage msg) {
        int statusCode = Util.getIntValue(msg, "HTTP_STATUS_CODE", 200);
        String reasonPhrase = Util.getStringValue(msg, "HTTP_REASON_PHRASE", HttpResponseStatus.valueOf(statusCode).reasonPhrase());
        return new HttpResponseStatus(statusCode, reasonPhrase);
    }

    public static HttpRequest createHttpRequest(HTTPCarbonMessage outboundRequestMsg) {
        HttpMethod httpMethod = Util.getHttpMethod(outboundRequestMsg);
        HttpVersion httpVersion = Util.getHttpVersion(outboundRequestMsg);
        String requestPath = Util.getRequestPath(outboundRequestMsg);
        DefaultHttpRequest outboundNettyRequest = new DefaultHttpRequest(httpVersion, httpMethod, (String)outboundRequestMsg.getProperty("TO"), false);
        outboundNettyRequest.setMethod(httpMethod);
        outboundNettyRequest.setProtocolVersion(httpVersion);
        outboundNettyRequest.setUri(requestPath);
        outboundNettyRequest.headers().add(outboundRequestMsg.getHeaders());
        return outboundNettyRequest;
    }

    private static String getRequestPath(HTTPCarbonMessage outboundRequestMsg) {
        if (outboundRequestMsg.getProperty("TO") == null) {
            outboundRequestMsg.setProperty("TO", "");
        }
        return (String)outboundRequestMsg.getProperty("TO");
    }

    private static HttpVersion getHttpVersion(HTTPCarbonMessage outboundRequestMsg) {
        HttpVersion httpVersion = null != outboundRequestMsg.getProperty("HTTP_VERSION") ? new HttpVersion("HTTP/" + outboundRequestMsg.getProperty("HTTP_VERSION"), true) : new HttpVersion("HTTP/1.1", true);
        return httpVersion;
    }

    private static HttpMethod getHttpMethod(HTTPCarbonMessage outboundRequestMsg) {
        HttpMethod httpMethod = null != outboundRequestMsg.getProperty("HTTP_METHOD") ? new HttpMethod((String)outboundRequestMsg.getProperty("HTTP_METHOD")) : new HttpMethod("POST");
        return httpMethod;
    }

    public static void setupChunkedRequest(HTTPCarbonMessage httpOutboundRequest) {
        httpOutboundRequest.removeHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
        Util.setTransferEncodingHeader(httpOutboundRequest);
    }

    public static HttpRequest createHttpRequestFromHttp2Headers(Http2Headers http2Headers, int streamId) throws Http2Exception {
        String method = "GET";
        if (http2Headers.method() != null) {
            method = ((CharSequence)http2Headers.getAndRemove(":method")).toString();
        }
        String path = "/";
        if (http2Headers.path() != null) {
            path = ((CharSequence)http2Headers.getAndRemove(":path")).toString();
        }
        http2Headers.getAndRemove(":authority");
        http2Headers.getAndRemove(":scheme");
        HttpVersion version = new HttpVersion("HTTP/2.0", true);
        DefaultHttpRequest httpRequest = new DefaultHttpRequest(version, HttpMethod.valueOf(method), path);
        HttpConversionUtil.addHttp2ToHttpHeaders(streamId, http2Headers, httpRequest.headers(), version, false, true);
        return httpRequest;
    }

    public static void setupContentLengthRequest(HTTPCarbonMessage httpOutboundRequest, int contentLength) {
        httpOutboundRequest.removeHeader(HttpHeaderNames.TRANSFER_ENCODING.toString());
        httpOutboundRequest.removeHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
        if (httpOutboundRequest.getHeader(HttpHeaderNames.CONTENT_LENGTH.toString()) == null) {
            httpOutboundRequest.setHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(contentLength));
        }
    }

    private static void setTransferEncodingHeader(HTTPCarbonMessage httpOutboundRequest) {
        if (httpOutboundRequest.getHeader(HttpHeaderNames.TRANSFER_ENCODING.toString()) == null) {
            httpOutboundRequest.setHeader(HttpHeaderNames.TRANSFER_ENCODING.toString(), "chunked");
        }
    }

    public static boolean isEntityBodyAllowed(String method) {
        return method.equals("POST") || method.equals("PUT") || method.equals("PATCH");
    }

    public static boolean isVersionCompatibleForChunking(String httpVersion) {
        return Float.valueOf(httpVersion).floatValue() >= 1.1f;
    }

    public static boolean shouldEnforceChunkingforHttpOneZero(ChunkConfig chunkConfig, String httpVersion) {
        return chunkConfig == ChunkConfig.ALWAYS && Float.valueOf(httpVersion).floatValue() >= 1.0f;
    }

    public static SSLConfig getSSLConfigForListener(String certPass, String keyStorePass, String keyStoreFilePath, String trustStoreFilePath, String trustStorePass, List<Parameter> parametersList, String verifyClient, String sslProtocol, String tlsStoreType) {
        if (certPass == null) {
            certPass = keyStorePass;
        }
        if (keyStoreFilePath == null || keyStorePass == null) {
            throw new IllegalArgumentException("keyStoreFile or keyStorePassword not defined for HTTPS scheme");
        }
        File keyStore = new File(Util.substituteVariables(keyStoreFilePath));
        if (!keyStore.exists()) {
            throw new IllegalArgumentException("KeyStore File " + keyStoreFilePath + " not found");
        }
        SSLConfig sslConfig = new SSLConfig(keyStore, keyStorePass).setCertPass(certPass);
        for (Parameter parameter : parametersList) {
            if (parameter.getName().equals("ciphers")) {
                sslConfig.setCipherSuites(parameter.getValue());
                continue;
            }
            if (parameter.getName().equals("sslEnabledProtocols")) {
                sslConfig.setEnableProtocols(parameter.getValue());
                continue;
            }
            if (parameter.getName().equals("server.supported.snimatchers")) {
                sslConfig.setSniMatchers(parameter.getValue());
                continue;
            }
            if (parameter.getName().equals("server.suported.server.names")) {
                sslConfig.setServerNames(parameter.getValue());
                continue;
            }
            if (!parameter.getName().equals("sessionCreation")) continue;
            sslConfig.setEnableSessionCreation(Boolean.parseBoolean(parameter.getValue()));
        }
        if ("require".equalsIgnoreCase(verifyClient)) {
            sslConfig.setNeedClientAuth(true);
        }
        sslProtocol = sslProtocol != null ? sslProtocol : "TLS";
        sslConfig.setSSLProtocol(sslProtocol);
        tlsStoreType = tlsStoreType != null ? tlsStoreType : "JKS";
        sslConfig.setTLSStoreType(tlsStoreType);
        if (trustStoreFilePath != null) {
            File trustStore = new File(Util.substituteVariables(trustStoreFilePath));
            if (!trustStore.exists()) {
                throw new IllegalArgumentException("trustStore File " + trustStoreFilePath + " not found");
            }
            if (trustStorePass == null) {
                throw new IllegalArgumentException("trustStorePass is not defined for HTTPS scheme");
            }
            sslConfig.setTrustStore(trustStore).setTrustStorePass(trustStorePass);
        }
        return sslConfig;
    }

    public static SSLConfig getSSLConfigForSender(String certPass, String keyStorePass, String keyStoreFilePath, String trustStoreFilePath, String trustStorePass, List<Parameter> parametersList, String sslProtocol, String tlsStoreType) {
        if (certPass == null) {
            certPass = keyStorePass;
        }
        if (trustStoreFilePath == null || trustStorePass == null) {
            throw new IllegalArgumentException("TrusStoreFile or trustStorePassword not defined for HTTPS scheme");
        }
        SSLConfig sslConfig = new SSLConfig(null, null).setCertPass(null);
        if (keyStoreFilePath != null) {
            File keyStore = new File(Util.substituteVariables(keyStoreFilePath));
            if (!keyStore.exists()) {
                throw new IllegalArgumentException("KeyStore File " + trustStoreFilePath + " not found");
            }
            sslConfig = new SSLConfig(keyStore, keyStorePass).setCertPass(certPass);
        }
        File trustStore = new File(Util.substituteVariables(trustStoreFilePath));
        sslConfig.setTrustStore(trustStore).setTrustStorePass(trustStorePass);
        sslProtocol = sslProtocol != null ? sslProtocol : "TLS";
        sslConfig.setSSLProtocol(sslProtocol);
        tlsStoreType = tlsStoreType != null ? tlsStoreType : "JKS";
        sslConfig.setTLSStoreType(tlsStoreType);
        if (parametersList != null) {
            for (Parameter parameter : parametersList) {
                String paramName = parameter.getName();
                if ("ciphers".equals(paramName)) {
                    sslConfig.setCipherSuites(parameter.getValue());
                    continue;
                }
                if ("sslEnabledProtocols".equals(paramName)) {
                    sslConfig.setEnableProtocols(parameter.getValue());
                    continue;
                }
                if (!"sessionCreation".equals(paramName)) continue;
                sslConfig.setEnableSessionCreation(Boolean.parseBoolean(parameter.getValue()));
            }
        }
        return sslConfig;
    }

    public static int getIntProperty(Map<String, Object> properties, String key, int defaultVal) {
        if (properties == null) {
            return defaultVal;
        }
        Object propertyVal = properties.get(key);
        if (propertyVal == null) {
            return defaultVal;
        }
        if (!(propertyVal instanceof Integer)) {
            throw new IllegalArgumentException("Property : " + key + " must be an integer");
        }
        return (Integer)propertyVal;
    }

    public static String getStringProperty(Map<String, Object> properties, String key, String defaultVal) {
        if (properties == null) {
            return defaultVal;
        }
        Object propertyVal = properties.get(key);
        if (propertyVal == null) {
            return defaultVal;
        }
        if (!(propertyVal instanceof String)) {
            throw new IllegalArgumentException("Property : " + key + " must be a string");
        }
        return (String)propertyVal;
    }

    public static Boolean getBooleanProperty(Map<String, Object> properties, String key, boolean defaultVal) {
        if (properties == null) {
            return defaultVal;
        }
        Object propertyVal = properties.get(key);
        if (propertyVal == null) {
            return defaultVal;
        }
        if (!(propertyVal instanceof Boolean)) {
            throw new IllegalArgumentException("Property : " + key + " must be a boolean");
        }
        return (Boolean)propertyVal;
    }

    public static Long getLongProperty(Map<String, Object> properties, String key, long defaultVal) {
        if (properties == null) {
            return defaultVal;
        }
        Object propertyVal = properties.get(key);
        if (propertyVal == null) {
            return defaultVal;
        }
        if (!(propertyVal instanceof Long)) {
            throw new IllegalArgumentException("Property : " + key + " must be a long");
        }
        return (Long)propertyVal;
    }

    private static String substituteVariables(String value) {
        Matcher matcher = varPattern.matcher(value);
        boolean found = matcher.find();
        if (!found) {
            return value;
        }
        StringBuffer sb = new StringBuffer();
        do {
            String sysPropKey;
            String sysPropValue;
            if ((sysPropValue = Util.getSystemVariableValue(sysPropKey = matcher.group(1), null)) == null || sysPropValue.length() == 0) {
                throw new RuntimeException("System property " + sysPropKey + " is not specified");
            }
            sysPropValue = sysPropValue.replace("\\", "\\\\");
            matcher.appendReplacement(sb, sysPropValue);
        } while (matcher.find());
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String getSystemVariableValue(String variableName, String defaultValue) {
        String value = System.getProperty(variableName) != null ? System.getProperty(variableName) : (System.getenv(variableName) != null ? System.getenv(variableName) : defaultValue);
        return value;
    }

    public static String createServerConnectorID(String host, int port) {
        return host + ":" + port;
    }

    public static void resetChannelAttributes(ChannelHandlerContext ctx) {
        ctx.channel().attr(Constants.RESPONSE_FUTURE_OF_ORIGINAL_CHANNEL).set(null);
        ctx.channel().attr(Constants.ORIGINAL_REQUEST).set(null);
        ctx.channel().attr(Constants.REDIRECT_COUNT).set(null);
        ctx.channel().attr(Constants.ORIGINAL_CHANNEL_START_TIME).set(null);
        ctx.channel().attr(Constants.ORIGINAL_CHANNEL_TIMEOUT).set(null);
    }

    public static boolean isLastHttpContent(HttpContent httpContent) {
        return httpContent instanceof LastHttpContent;
    }

    public static void sendAndCloseNoEntityBodyResp(ChannelHandlerContext ctx, HttpResponseStatus status, HttpVersion httpVersion, String serverName) {
        DefaultHttpResponse outboundResponse = new DefaultHttpResponse(httpVersion, status);
        outboundResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        outboundResponse.headers().set(HttpHeaderNames.CONNECTION.toString(), (Object)"close");
        outboundResponse.headers().set(HttpHeaderNames.SERVER.toString(), (Object)serverName);
        ChannelFuture outboundRespFuture = ctx.channel().writeAndFlush(outboundResponse);
        outboundRespFuture.addListener(channelFuture -> log.warn("Failed to send " + status.reasonPhrase()));
        ctx.channel().close();
    }

    public static void checkForResponseWriteStatus(HTTPCarbonMessage inboundRequestMsg, HttpResponseFuture outboundRespStatusFuture, ChannelFuture channelFuture) {
        channelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)writeOperationPromise -> {
            Throwable throwable = writeOperationPromise.cause();
            if (throwable != null) {
                if (throwable instanceof ClosedChannelException) {
                    throwable = new IOException("Remote client closed the connection before completing outbound response");
                }
                log.error("Remote client closed the connection before completing outbound response", throwable);
                outboundRespStatusFuture.notifyHttpListener(throwable);
            } else {
                outboundRespStatusFuture.notifyHttpListener(inboundRequestMsg);
            }
        }));
    }

    public static void addResponseWriteFailureListener(HttpResponseFuture outboundRespStatusFuture, ChannelFuture channelFuture) {
        channelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)writeOperationPromise -> {
            Throwable throwable = writeOperationPromise.cause();
            if (throwable != null) {
                if (throwable instanceof ClosedChannelException) {
                    throwable = new IOException("Remote client closed the connection before completing outbound response");
                }
                log.error("Remote client closed the connection before completing outbound response", throwable);
                outboundRespStatusFuture.notifyHttpListener(throwable);
            }
        }));
    }
}

