/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.websocket.message;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.wso2.transport.http.netty.contract.websocket.HandshakeFuture;
import org.wso2.transport.http.netty.contract.websocket.WebSocketInitMessage;
import org.wso2.transport.http.netty.contractimpl.websocket.HandshakeFutureImpl;
import org.wso2.transport.http.netty.contractimpl.websocket.WebSocketMessageImpl;
import org.wso2.transport.http.netty.internal.websocket.WebSocketSessionImpl;
import org.wso2.transport.http.netty.internal.websocket.WebSocketUtil;
import org.wso2.transport.http.netty.listener.WebSocketSourceHandler;

public class DefaultWebSocketInitMessage
extends WebSocketMessageImpl
implements WebSocketInitMessage {
    private final ChannelHandlerContext ctx;
    private final HttpRequest httpRequest;
    private final WebSocketSourceHandler webSocketSourceHandler;
    private boolean isCancelled = false;
    private boolean handshakeStarted = false;
    private HttpRequest request;

    public DefaultWebSocketInitMessage(ChannelHandlerContext ctx, HttpRequest httpRequest, WebSocketSourceHandler webSocketSourceHandler, Map<String, String> headers) {
        this.ctx = ctx;
        this.httpRequest = httpRequest;
        this.webSocketSourceHandler = webSocketSourceHandler;
        this.headers = headers;
        this.sessionlID = WebSocketUtil.getSessionID(ctx);
    }

    @Override
    public HandshakeFuture handshake() {
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketURL(this.httpRequest), null, true);
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker(this.httpRequest);
        return this.handleHandshake(handshaker, 0, null);
    }

    @Override
    public HandshakeFuture handshake(String[] subProtocols, boolean allowExtensions) {
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketURL(this.httpRequest), this.getSubProtocolsCSV(subProtocols), allowExtensions);
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker(this.httpRequest);
        return this.handleHandshake(handshaker, 0, null);
    }

    @Override
    public HandshakeFuture handshake(String[] subProtocols, boolean allowExtensions, int idleTimeout) {
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketURL(this.httpRequest), this.getSubProtocolsCSV(subProtocols), allowExtensions);
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker(this.httpRequest);
        return this.handleHandshake(handshaker, idleTimeout, null);
    }

    @Override
    public HandshakeFuture handshake(String[] subProtocols, boolean allowExtensions, int idleTimeout, HttpHeaders responseHeaders) {
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketURL(this.httpRequest), this.getSubProtocolsCSV(subProtocols), allowExtensions);
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker(this.httpRequest);
        return this.handleHandshake(handshaker, idleTimeout, responseHeaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelHandShake(int closeCode, String closeReason) {
        try {
            WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketURL(this.httpRequest), this.getSubProtocol(), true);
            WebSocketServerHandshaker handshaker = wsFactory.newHandshaker(this.httpRequest);
            ChannelFuture channelFuture = handshaker.close(this.ctx.channel(), new CloseWebSocketFrame(closeCode, closeReason));
            channelFuture.channel().close();
        }
        finally {
            this.isCancelled = true;
        }
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public boolean isHandshakeStarted() {
        return this.handshakeStarted;
    }

    private HandshakeFuture handleHandshake(WebSocketServerHandshaker handshaker, int idleTimeout, HttpHeaders headers) {
        HandshakeFutureImpl handshakeFuture = new HandshakeFutureImpl();
        if (this.isCancelled) {
            IllegalAccessException e = new IllegalAccessException("Handshake is already cancelled!");
            handshakeFuture.notifyError(e);
            return handshakeFuture;
        }
        try {
            ChannelFuture future = handshaker.handshake(this.ctx.channel(), this.httpRequest, headers, this.ctx.channel().newPromise());
            handshakeFuture.setChannelFuture(future);
            future.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future1 -> {
                String selectedSubProtocol = handshaker.selectedSubprotocol();
                this.webSocketSourceHandler.setNegotiatedSubProtocol(selectedSubProtocol);
                this.setSubProtocol(selectedSubProtocol);
                WebSocketSessionImpl session = (WebSocketSessionImpl)this.getChannelSession();
                session.setIsOpen(true);
                session.setNegotiatedSubProtocol(selectedSubProtocol);
                ChannelPipeline pipeline = this.ctx.pipeline();
                if (idleTimeout > 0) {
                    pipeline.replace("idleStateHandler", "idleStateHandler", (ChannelHandler)new IdleStateHandler(idleTimeout, idleTimeout, idleTimeout, TimeUnit.MILLISECONDS));
                } else {
                    pipeline.remove("idleStateHandler");
                }
                pipeline.addLast("ws_handler", (ChannelHandler)this.webSocketSourceHandler);
                pipeline.remove("SourceHandler");
                this.setProperty("SRC_HANDLER", this.webSocketSourceHandler);
                handshakeFuture.notifySuccess(this.webSocketSourceHandler.getChannelSession());
            }));
            this.handshakeStarted = true;
            return handshakeFuture;
        }
        catch (Exception e) {
            handshaker.close(this.ctx.channel(), new CloseWebSocketFrame(1002, "Terminating the connection due to a protocol error."));
            handshakeFuture.notifyError(e);
            return handshakeFuture;
        }
    }

    private String getWebSocketURL(HttpRequest req) {
        String protocol = "ws";
        if (this.isConnectionSecured) {
            protocol = "wss";
        }
        String url = protocol + "://" + req.headers().get("Host") + req.uri();
        return url;
    }

    private String getSubProtocolsCSV(String[] subProtocols) {
        if (subProtocols == null || subProtocols.length == 0) {
            return null;
        }
        String subProtocolsStr = "";
        for (String subProtocol : subProtocols) {
            subProtocolsStr = subProtocolsStr.concat(subProtocol + ",");
        }
        subProtocolsStr = subProtocolsStr.substring(0, subProtocolsStr.length() - 1);
        return subProtocolsStr;
    }

    public HttpRequest getHttpRequest() {
        return this.request;
    }

    public void setHttpRequest(HttpRequest request) {
        this.request = request;
    }
}

