/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.message;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpMessage;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.DefaultHttpResponseFuture;
import org.wso2.transport.http.netty.contractimpl.HttpWsServerConnectorFuture;
import org.wso2.transport.http.netty.message.BlockingEntityCollector;
import org.wso2.transport.http.netty.message.EntityCollector;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.MessageFuture;

public class HTTPCarbonMessage {
    protected HttpMessage httpMessage;
    private EntityCollector blockingEntityCollector;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private MessageFuture messageFuture;
    private final ServerConnectorFuture httpOutboundRespFuture = new HttpWsServerConnectorFuture();
    private final DefaultHttpResponseFuture httpOutboundRespStatusFuture = new DefaultHttpResponseFuture();

    public HTTPCarbonMessage(HttpMessage httpMessage) {
        this.httpMessage = httpMessage;
        this.setBlockingEntityCollector(new BlockingEntityCollector(300000));
    }

    public HTTPCarbonMessage(HttpMessage httpMessage, int maxWaitTime) {
        this.httpMessage = httpMessage;
        this.setBlockingEntityCollector(new BlockingEntityCollector(maxWaitTime));
    }

    public synchronized void addHttpContent(HttpContent httpContent) {
        if (this.messageFuture != null) {
            this.messageFuture.notifyMessageListener(httpContent);
        } else {
            this.blockingEntityCollector.addHttpContent(httpContent);
        }
    }

    public HttpContent getHttpContent() {
        return this.blockingEntityCollector.getHttpContent();
    }

    public synchronized MessageFuture getHttpContentAsync() {
        this.messageFuture = new MessageFuture(this);
        return this.messageFuture;
    }

    @Deprecated
    public ByteBuf getMessageBody() {
        return this.blockingEntityCollector.getMessageBody();
    }

    public boolean isEmpty() {
        return this.blockingEntityCollector.isEmpty();
    }

    public int countMessageLengthTill(int maxLength) {
        return this.blockingEntityCollector.countMessageLengthTill(maxLength);
    }

    public int getFullMessageLength() {
        return this.blockingEntityCollector.getFullMessageLength();
    }

    @Deprecated
    public void addMessageBody(ByteBuffer msgBody) {
        this.blockingEntityCollector.addMessageBody(msgBody);
    }

    public void completeMessage() {
        this.blockingEntityCollector.completeMessage();
    }

    public HttpHeaders getHeaders() {
        return this.httpMessage.headers();
    }

    public String getHeader(String key) {
        return this.httpMessage.headers().get(key);
    }

    public void setHeader(String key, String value) {
        this.httpMessage.headers().set(key, (Object)value);
    }

    public void setHeaders(HttpHeaders httpHeaders) {
        this.httpMessage.headers().setAll(httpHeaders);
    }

    public void removeHeader(String key) {
        this.httpMessage.headers().remove(key);
    }

    public Object getProperty(String key) {
        if (this.properties != null) {
            return this.properties.get(key);
        }
        return null;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    private void setBlockingEntityCollector(BlockingEntityCollector blockingEntityCollector) {
        this.blockingEntityCollector = blockingEntityCollector;
    }

    public ServerConnectorFuture getHttpResponseFuture() {
        return this.httpOutboundRespFuture;
    }

    public HttpResponseFuture getHttpOutboundRespStatusFuture() {
        return this.httpOutboundRespStatusFuture;
    }

    public HttpResponseFuture respond(HTTPCarbonMessage httpCarbonMessage) throws ServerConnectorException {
        this.httpOutboundRespFuture.notifyHttpListener(httpCarbonMessage);
        return this.httpOutboundRespStatusFuture;
    }

    public HttpResponseFuture pushResponse(HTTPCarbonMessage httpCarbonMessage, Http2PushPromise pushPromise) throws ServerConnectorException {
        this.httpOutboundRespFuture.notifyHttpListener(httpCarbonMessage, pushPromise);
        return this.httpOutboundRespStatusFuture;
    }

    public HttpResponseFuture pushPromise(Http2PushPromise pushPromise) throws ServerConnectorException {
        this.httpOutboundRespFuture.notifyHttpListener(pushPromise);
        return this.httpOutboundRespStatusFuture;
    }

    public HTTPCarbonMessage cloneCarbonMessageWithOutData() {
        HTTPCarbonMessage newCarbonMessage = this.getNewHttpCarbonMessage();
        Map<String, Object> propertiesMap = this.getProperties();
        propertiesMap.forEach(newCarbonMessage::setProperty);
        return newCarbonMessage;
    }

    private HTTPCarbonMessage getNewHttpCarbonMessage() {
        DefaultHttpHeaders httpHeaders;
        DefaultHttpMessage newHttpMessage;
        if (this.httpMessage instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)this.httpMessage;
            newHttpMessage = new DefaultHttpRequest(this.httpMessage.protocolVersion(), ((HttpRequest)this.httpMessage).method(), httpRequest.uri());
            httpHeaders = new DefaultHttpHeaders();
            List<Map.Entry<String, String>> headerList = this.httpMessage.headers().entries();
            for (Map.Entry<String, String> entry : headerList) {
                ((HttpHeaders)httpHeaders).add(entry.getKey(), (Object)entry.getValue());
            }
        } else {
            HttpResponse httpResponse = (HttpResponse)this.httpMessage;
            newHttpMessage = new DefaultFullHttpResponse(this.httpMessage.protocolVersion(), httpResponse.status());
            httpHeaders = new DefaultHttpHeaders();
            List<Map.Entry<String, String>> headerList = this.httpMessage.headers().entries();
            for (Map.Entry<String, String> entry : headerList) {
                ((HttpHeaders)httpHeaders).add(entry.getKey(), (Object)entry.getValue());
            }
        }
        HTTPCarbonMessage httpCarbonMessage = new HTTPCarbonMessage(newHttpMessage);
        httpCarbonMessage.getHeaders().set(httpHeaders);
        return httpCarbonMessage;
    }

    public void waitAndReleaseAllEntities() {
        this.blockingEntityCollector.waitAndReleaseAllEntities();
    }

    public EntityCollector getBlockingEntityCollector() {
        return this.blockingEntityCollector;
    }

    public synchronized void removeHttpContentAsyncFuture() {
        this.messageFuture = null;
    }

    public HttpRequest getNettyHttpRequest() {
        return (HttpRequest)this.httpMessage;
    }

    public HttpResponse getNettyHttpResponse() {
        return (HttpResponse)this.httpMessage;
    }
}

