/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.listener;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.common.ssl.SSLConfig;
import org.wso2.transport.http.netty.config.ChunkConfig;
import org.wso2.transport.http.netty.config.KeepAliveConfig;
import org.wso2.transport.http.netty.config.RequestSizeValidationConfig;
import org.wso2.transport.http.netty.contract.ServerConnector;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.HttpWsServerConnectorFuture;
import org.wso2.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.transport.http.netty.internal.HandlerExecutor;
import org.wso2.transport.http.netty.listener.HttpServerChannelInitializer;
import org.wso2.transport.http.netty.listener.ServerBootstrapConfiguration;

public class ServerConnectorBootstrap {
    private static final Logger log = LoggerFactory.getLogger(ServerConnectorBootstrap.class);
    private ServerBootstrap serverBootstrap = new ServerBootstrap();
    private HttpServerChannelInitializer httpServerChannelInitializer = new HttpServerChannelInitializer();
    private boolean initialized = false;
    private boolean isHttps = false;
    private ChannelGroup allChannels;

    public ServerConnectorBootstrap(ChannelGroup allChannels) {
        this.httpServerChannelInitializer.setAllChannels(allChannels);
        this.serverBootstrap.childHandler(this.httpServerChannelInitializer);
        HTTPTransportContextHolder.getInstance().setHandlerExecutor(new HandlerExecutor());
        this.initialized = true;
        this.allChannels = allChannels;
    }

    private ChannelFuture bindInterface(HTTPServerConnector serverConnector) {
        if (!this.initialized) {
            log.error("ServerConnectorBootstrap is not initialized");
            return null;
        }
        return this.serverBootstrap.bind(new InetSocketAddress(serverConnector.getHost(), serverConnector.getPort()));
    }

    private boolean unBindInterface(HTTPServerConnector serverConnector) throws InterruptedException {
        if (!this.initialized) {
            log.error("ServerConnectorBootstrap is not initialized");
            return false;
        }
        ChannelFuture future = serverConnector.getChannelFuture();
        if (future != null) {
            ChannelFuture channelFuture = future.channel().close();
            channelFuture.sync();
            log.info("HttpConnectorListener stopped listening on host " + serverConnector.getHost() + " and port " + serverConnector.getPort());
            return true;
        }
        return false;
    }

    public ServerConnector getServerConnector(String host, int port) {
        String serverConnectorId = Util.createServerConnectorID(host, port);
        return new HTTPServerConnector(serverConnectorId, this, host, port);
    }

    public void addSocketConfiguration(ServerBootstrapConfiguration serverBootstrapConfiguration) {
        this.serverBootstrap.option(ChannelOption.SO_BACKLOG, serverBootstrapConfiguration.getSoBackLog());
        this.serverBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, serverBootstrapConfiguration.getConnectTimeOut());
        this.serverBootstrap.option(ChannelOption.SO_RCVBUF, serverBootstrapConfiguration.getReceiveBufferSize());
        this.serverBootstrap.childOption(ChannelOption.TCP_NODELAY, serverBootstrapConfiguration.isTcpNoDelay());
        this.serverBootstrap.childOption(ChannelOption.SO_RCVBUF, serverBootstrapConfiguration.getReceiveBufferSize());
        this.serverBootstrap.childOption(ChannelOption.SO_SNDBUF, serverBootstrapConfiguration.getSendBufferSize());
        if (log.isDebugEnabled()) {
            log.debug(String.format("Netty Server Socket BACKLOG %d", serverBootstrapConfiguration.getSoBackLog()));
            log.debug(String.format("Netty Server Socket TCP_NODELAY %s", serverBootstrapConfiguration.isTcpNoDelay()));
            log.debug(String.format("Netty Server Socket CONNECT_TIMEOUT_MILLIS %d", serverBootstrapConfiguration.getConnectTimeOut()));
            log.debug(String.format("Netty Server Socket SO_RCVBUF %d", serverBootstrapConfiguration.getReceiveBufferSize()));
            log.debug(String.format("Netty Server Socket SO_SNDBUF %d", serverBootstrapConfiguration.getSendBufferSize()));
        }
    }

    public void addSecurity(SSLConfig sslConfig) {
        if (sslConfig != null) {
            this.httpServerChannelInitializer.setSslConfig(sslConfig);
            this.isHttps = true;
        }
    }

    public void addIdleTimeout(int socketIdleTimeout) {
        this.httpServerChannelInitializer.setIdleTimeout(socketIdleTimeout);
    }

    public void setHttp2Enabled(boolean isHttp2Enabled) {
        this.httpServerChannelInitializer.setHttp2Enabled(isHttp2Enabled);
    }

    public void addThreadPools(EventLoopGroup bossGroup, EventLoopGroup workerGroup) {
        this.serverBootstrap.group(bossGroup, workerGroup).channel(NioServerSocketChannel.class);
    }

    public void addHttpTraceLogHandler(Boolean isHttpTraceLogEnabled) {
        this.httpServerChannelInitializer.setHttpTraceLogEnabled(isHttpTraceLogEnabled);
    }

    public void addHttpAccessLogHandler(Boolean isHttpAccessLogEnabled) {
        this.httpServerChannelInitializer.setHttpAccessLogEnabled(isHttpAccessLogEnabled);
    }

    public void addHeaderAndEntitySizeValidation(RequestSizeValidationConfig requestSizeValidationConfig) {
        this.httpServerChannelInitializer.setReqSizeValidationConfig(requestSizeValidationConfig);
    }

    public void addcertificateRevocationVerifier(Boolean validateCertEnabled) {
        this.httpServerChannelInitializer.setValidateCertEnabled(validateCertEnabled);
    }

    public void addCacheDelay(int cacheDelay) {
        this.httpServerChannelInitializer.setCacheDelay(cacheDelay);
    }

    public void addCacheSize(int cacheSize) {
        this.httpServerChannelInitializer.setCacheSize(cacheSize);
    }

    public void addOcspStapling(boolean ocspStapling) {
        this.httpServerChannelInitializer.setOcspStaplingEnabled(ocspStapling);
    }

    public void addChunkingBehaviour(ChunkConfig chunkConfig) {
        this.httpServerChannelInitializer.setChunkingConfig(chunkConfig);
    }

    public void addKeepAliveBehaviour(KeepAliveConfig keepAliveConfig) {
        this.httpServerChannelInitializer.setKeepAliveConfig(keepAliveConfig);
    }

    public void addServerHeader(String serverName) {
        this.httpServerChannelInitializer.setServerName(serverName);
    }

    class HTTPServerConnector
    implements ServerConnector {
        private final Logger log = LoggerFactory.getLogger(HTTPServerConnector.class);
        private ChannelFuture channelFuture;
        private ServerConnectorFuture serverConnectorFuture;
        private ServerConnectorBootstrap serverConnectorBootstrap;
        private String host;
        private int port;
        private String connectorID;

        HTTPServerConnector(String id, ServerConnectorBootstrap serverConnectorBootstrap, String host, int port) {
            this.serverConnectorBootstrap = serverConnectorBootstrap;
            this.host = host;
            this.port = port;
            this.connectorID = id;
            ServerConnectorBootstrap.this.httpServerChannelInitializer.setInterfaceId(id);
        }

        @Override
        public ServerConnectorFuture start() {
            this.channelFuture = ServerConnectorBootstrap.this.bindInterface(this);
            this.serverConnectorFuture = new HttpWsServerConnectorFuture(this.channelFuture, ServerConnectorBootstrap.this.allChannels);
            this.channelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)channelFuture -> {
                if (channelFuture.isSuccess()) {
                    this.log.info("HTTP(S) Interface starting on host " + this.getHost() + " and port " + this.getPort());
                    this.serverConnectorFuture.notifyPortBindingEvent(this.connectorID, ServerConnectorBootstrap.this.isHttps);
                } else {
                    this.serverConnectorFuture.notifyPortBindingError(channelFuture.cause());
                }
            }));
            ServerConnectorBootstrap.this.httpServerChannelInitializer.setServerConnectorFuture(this.serverConnectorFuture);
            return this.serverConnectorFuture;
        }

        @Override
        public boolean stop() {
            boolean connectorStopped = false;
            try {
                connectorStopped = this.serverConnectorBootstrap.unBindInterface(this);
                if (connectorStopped) {
                    this.serverConnectorFuture.notifyPortUnbindingEvent(this.connectorID, ServerConnectorBootstrap.this.isHttps);
                }
            }
            catch (InterruptedException e) {
                this.log.error("Couldn't close the port", e);
                return false;
            }
            catch (ServerConnectorException e) {
                this.log.error("Error in notifying life cycle event listener", e);
            }
            return connectorStopped;
        }

        @Override
        public String getConnectorID() {
            return this.connectorID;
        }

        private ChannelFuture getChannelFuture() {
            return this.channelFuture;
        }

        public String toString() {
            return this.host + "-" + this.port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }
}

