/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.entitywriter;

import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.wso2.msf4j.internal.ClassComparator;
import org.wso2.msf4j.internal.entitywriter.EntityWriter;
import org.wso2.msf4j.internal.entitywriter.FileEntityWriter;
import org.wso2.msf4j.internal.entitywriter.InputStreamEntityWriter;
import org.wso2.msf4j.internal.entitywriter.ObjectEntityWriter;
import org.wso2.msf4j.internal.entitywriter.StreamingOutputEntityWriter;

public class EntityWriterRegistry {
    private static final EntityWriter DEFAULT_ENTITY_WRITER = new ObjectEntityWriter();
    private static final Map<Class, EntityWriter> writers = new TreeMap<Class, EntityWriter>(new ClassComparator());

    private EntityWriterRegistry() {
    }

    private static void registerEntityWriter(EntityWriter entityWriter) {
        writers.put(entityWriter.getType(), entityWriter);
    }

    public static EntityWriter getEntityWriter(Class type) {
        return writers.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(type)).findFirst().flatMap(entry -> Optional.ofNullable(entry.getValue())).orElse(DEFAULT_ENTITY_WRITER);
    }

    static {
        EntityWriterRegistry.registerEntityWriter(new FileEntityWriter());
        EntityWriterRegistry.registerEntityWriter(new InputStreamEntityWriter());
        EntityWriterRegistry.registerEntityWriter(new StreamingOutputEntityWriter());
    }
}

