/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.states;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.config.ChunkConfig;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.states.SenderReqRespStateManager;
import org.wso2.transport.http.netty.contractimpl.common.states.StateUtil;
import org.wso2.transport.http.netty.contractimpl.sender.TargetHandler;
import org.wso2.transport.http.netty.contractimpl.sender.channel.TargetChannel;
import org.wso2.transport.http.netty.contractimpl.sender.states.ReceivingHeaders;
import org.wso2.transport.http.netty.contractimpl.sender.states.SenderState;
import org.wso2.transport.http.netty.contractimpl.sender.states.SendingEntityBody;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class SendingHeaders
implements SenderState {
    private static final Logger LOG = LoggerFactory.getLogger(SendingHeaders.class);
    private final String httpVersion;
    private final ChunkConfig chunkConfig;
    private final TargetChannel targetChannel;
    private final SenderReqRespStateManager senderReqRespStateManager;
    private final HttpResponseFuture httpInboundResponseFuture;

    public SendingHeaders(SenderReqRespStateManager senderReqRespStateManager, TargetChannel targetChannel, String httpVersion, ChunkConfig chunkConfig, HttpResponseFuture httpInboundResponseFuture) {
        this.senderReqRespStateManager = senderReqRespStateManager;
        this.targetChannel = targetChannel;
        this.httpVersion = httpVersion;
        this.chunkConfig = chunkConfig;
        this.httpInboundResponseFuture = httpInboundResponseFuture;
    }

    @Override
    public void writeOutboundRequestHeaders(HttpCarbonMessage httpOutboundRequest, HttpContent httpContent) {
        if (Util.isLastHttpContent(httpContent)) {
            if (Util.checkContentLengthAndTransferEncodingHeaderAllowance(httpOutboundRequest)) {
                if (this.chunkConfig == ChunkConfig.ALWAYS && StateUtil.checkChunkingCompatibility(this.httpVersion, this.chunkConfig)) {
                    Util.setupChunkedRequest(httpOutboundRequest);
                } else {
                    long contentLength = httpContent.content().readableBytes();
                    Util.setupContentLengthRequest(httpOutboundRequest, contentLength);
                }
            }
            StateUtil.writeRequestHeaders(httpOutboundRequest, this.httpInboundResponseFuture, this.httpVersion, this.targetChannel);
            this.writeRequestBody(httpOutboundRequest, httpContent, true);
        } else {
            if ((this.chunkConfig == ChunkConfig.ALWAYS || this.chunkConfig == ChunkConfig.AUTO) && StateUtil.checkChunkingCompatibility(this.httpVersion, this.chunkConfig)) {
                Util.setupChunkedRequest(httpOutboundRequest);
                StateUtil.writeRequestHeaders(httpOutboundRequest, this.httpInboundResponseFuture, this.httpVersion, this.targetChannel);
                this.writeRequestBody(httpOutboundRequest, httpContent, true);
                return;
            }
            this.writeRequestBody(httpOutboundRequest, httpContent, false);
        }
    }

    @Override
    public void writeOutboundRequestEntity(HttpCarbonMessage httpOutboundRequest, HttpContent httpContent) {
        this.writeOutboundRequestHeaders(httpOutboundRequest, httpContent);
    }

    @Override
    public void readInboundResponseHeaders(TargetHandler targetHandler, HttpResponse httpInboundResponse) {
        targetHandler.getOutboundRequestMsg().setIoException(new IOException("Inbound response message already received"));
        this.senderReqRespStateManager.state = new ReceivingHeaders(this.senderReqRespStateManager);
        this.senderReqRespStateManager.readInboundResponseHeaders(targetHandler, httpInboundResponse);
    }

    @Override
    public void readInboundResponseEntityBody(ChannelHandlerContext ctx, HttpContent httpContent, HttpCarbonMessage inboundResponseMsg) {
        LOG.warn("readInboundResponseEntityBody {}", (Object)"is not a dependant action of this state");
    }

    @Override
    public void handleAbruptChannelClosure(HttpResponseFuture httpResponseFuture) {
        LOG.error("Remote host closed the connection while writing outbound request headers");
    }

    @Override
    public void handleIdleTimeoutConnectionClosure(HttpResponseFuture httpResponseFuture, String channelID) {
        LOG.error("Error in HTTP client: {}", (Object)"Idle timeout triggered while writing outbound request headers");
    }

    private void writeRequestBody(HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, boolean headersWritten) {
        this.senderReqRespStateManager.state = new SendingEntityBody(this.senderReqRespStateManager, this.targetChannel, headersWritten, this.httpInboundResponseFuture, this.httpVersion);
        this.senderReqRespStateManager.writeOutboundRequestEntity(outboundResponseMsg, httpContent);
    }
}

