/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.startupresolver.beans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;
import org.wso2.carbon.kernel.internal.startupresolver.StartupServiceCache;
import org.wso2.carbon.kernel.internal.startupresolver.beans.Capability;
import org.wso2.carbon.kernel.internal.startupresolver.beans.CapabilityProviderCapability;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;

public class StartupComponent {
    private String name;
    private List<String> requiredServiceList = new ArrayList<String>();
    private final List<Capability> expectedCapabilityList = Collections.synchronizedList(new ArrayList());
    private RequiredCapabilityListener listener;
    private List<CapabilityProviderCapability> pendingCapabilityProviderList = new ArrayList<CapabilityProviderCapability>();
    private Bundle bundle;
    private boolean satisfied = false;

    public StartupComponent(String componentName, Bundle bundle) {
        this.name = componentName;
        this.bundle = bundle;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getRequiredServices() {
        return this.requiredServiceList;
    }

    public void addRequiredServices(List<String> requiredServiceList) {
        this.requiredServiceList.addAll(requiredServiceList);
    }

    public void addRequiredService(String requiredService) {
        this.requiredServiceList.add(requiredService);
    }

    public boolean isServiceRequired(String service) {
        return this.requiredServiceList.contains(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExpectedCapability(Capability capability) {
        List<Capability> list = this.expectedCapabilityList;
        synchronized (list) {
            Capability expectedCapability = this.expectedCapabilityList.stream().filter(expCapability -> expCapability.getName().equals(capability.getName())).filter(expCapability -> !expCapability.isSecondCheck() && expCapability.getState() == Capability.CapabilityState.AVAILABLE).findFirst().orElse(null);
            if (expectedCapability != null) {
                expectedCapability.setSecondCheck(true);
                expectedCapability.setDirectDependency(capability.isDirectDependency());
            } else {
                this.expectedCapabilityList.add(capability);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCapability(Capability capability) {
        List<Capability> list = this.expectedCapabilityList;
        synchronized (list) {
            if (capability.getState() == Capability.CapabilityState.EXPECTED) {
                Optional<Capability> optCapability = this.expectedCapabilityList.stream().filter(expCapability -> expCapability.getName().equals(capability.getName())).filter(expCapability -> expCapability.getState() == Capability.CapabilityState.AVAILABLE).filter(expCapability -> !expCapability.isSecondCheck()).findFirst();
                if (optCapability.isPresent()) {
                    optCapability.get().setSecondCheck(true);
                } else {
                    this.expectedCapabilityList.add(capability);
                }
            } else {
                Optional<Capability> optCapability = this.expectedCapabilityList.stream().filter(expCapability -> expCapability.getName().equals(capability.getName())).filter(expCapability -> expCapability.getState() == Capability.CapabilityState.EXPECTED).findFirst();
                if (optCapability.isPresent()) {
                    optCapability.get().setState(Capability.CapabilityState.AVAILABLE);
                    optCapability.get().setSecondCheck(true);
                } else {
                    this.expectedCapabilityList.add(capability);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Capability> getPendingCapabilities() {
        Map<String, Long> availableServiceCounts = StartupServiceCache.getInstance().getAvailableService(this.name);
        List<Capability> list = this.expectedCapabilityList;
        synchronized (list) {
            Map expectedServiceCounts = this.expectedCapabilityList.stream().filter(expCapability -> expCapability.isDirectDependency() || !expCapability.isDirectDependency() && expCapability.getState() == Capability.CapabilityState.EXPECTED).map(expCapability -> expCapability.getName()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            availableServiceCounts.forEach((s2, aLong) -> {
                Long eCount = (Long)expectedServiceCounts.get(s2);
                if (eCount != null && aLong >= eCount) {
                    expectedServiceCounts.remove(s2);
                }
            });
            if (expectedServiceCounts.isEmpty()) {
                return Collections.emptyList();
            }
            return this.expectedCapabilityList.stream().filter(expCapability -> expectedServiceCounts.keySet().contains(expCapability.getName())).collect(Collectors.toList());
        }
    }

    public RequiredCapabilityListener getListener() {
        return this.listener;
    }

    public void setListener(RequiredCapabilityListener listener) {
        this.listener = listener;
    }

    public void addExpectedOrAvailableCapabilityProvider(CapabilityProviderCapability capabilityProvider) {
        if (this.pendingCapabilityProviderList.contains(capabilityProvider)) {
            this.pendingCapabilityProviderList.remove(capabilityProvider);
        } else {
            this.pendingCapabilityProviderList.add(capabilityProvider);
        }
    }

    public List<CapabilityProviderCapability> getPendingCapabilityProviders() {
        return Collections.unmodifiableList(this.pendingCapabilityProviderList);
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public boolean isSatisfied() {
        return this.satisfied;
    }

    public void setSatisfied(boolean satisfied) {
        this.satisfied = satisfied;
    }

    public boolean isSatisfiable() {
        return !this.satisfied && this.getPendingCapabilities().size() == 0 && this.listener != null && this.pendingCapabilityProviderList.size() == 0;
    }

    public boolean isPending() {
        return !this.satisfied;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StartupComponent)) {
            return false;
        }
        StartupComponent other = (StartupComponent)obj;
        return this.getName().equals(other.getName()) && this.bundle.equals(other.bundle);
    }

    public int hashCode() {
        assert (false);
        return 10;
    }
}

