/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.swagger;

import io.swagger.jaxrs.Reader;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class MSF4JBeanConfig
extends BeanConfig {
    private Set<Class<?>> classes = new HashSet();
    private Reader reader;

    public MSF4JBeanConfig(Reader reader) {
        this.reader = reader;
    }

    @Override
    public Set<Class<?>> classes() {
        return Collections.unmodifiableSet(this.classes);
    }

    public void addServiceClass(Class<?> clazz) {
        this.classes.add(clazz);
    }

    @Override
    public void scanAndRead() {
        Swagger swagger = this.reader.read(this.classes());
        if (StringUtils.isNotBlank(this.getHost())) {
            swagger.setHost(this.getHost());
        }
        if (StringUtils.isNotBlank(this.getBasePath())) {
            swagger.setBasePath(this.getBasePath());
        }
        this.updateInfoFromConfig();
    }

    private void updateInfoFromConfig() {
        if (this.getSwagger().getInfo() == null) {
            this.setInfo(new Info());
        }
        if (StringUtils.isNotBlank(this.getDescription())) {
            this.getSwagger().getInfo().setDescription(this.getDescription());
        }
        if (StringUtils.isNotBlank(this.getTitle())) {
            this.getSwagger().getInfo().setTitle(this.getTitle());
        }
        if (StringUtils.isNotBlank(this.getVersion())) {
            this.getSwagger().getInfo().setVersion(this.getVersion());
        }
        if (StringUtils.isNotBlank(this.getTermsOfServiceUrl())) {
            this.getSwagger().getInfo().setTermsOfService(this.getTermsOfServiceUrl());
        }
        if (this.getContact() != null) {
            this.getSwagger().getInfo().setContact(new Contact().name(this.getContact()));
        }
        if (this.getLicense() != null && this.getLicenseUrl() != null) {
            this.getSwagger().getInfo().setLicense(new License().name(this.getLicense()).url(this.getLicenseUrl()));
        }
        if (this.getSchemes() != null) {
            for (String scheme : this.getSchemes()) {
                this.reader.getSwagger().scheme(Scheme.forValue(scheme));
            }
        }
        this.reader.getSwagger().setInfo(this.getInfo());
    }

    @Override
    public Swagger getSwagger() {
        return this.reader.getSwagger();
    }
}

