/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.swagger;

import io.swagger.models.Swagger;
import io.swagger.util.Json;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.wso2.msf4j.MicroservicesRegistry;
import org.wso2.msf4j.SwaggerService;
import org.wso2.msf4j.swagger.ExtendedSwaggerReader;
import org.wso2.msf4j.swagger.MSF4JBeanConfig;

@Path(value="/swagger")
public class SwaggerDefinitionService
implements SwaggerService {
    private static final String GLOBAL = "global";
    private Map<String, MSF4JBeanConfig> swaggerBeans = new HashMap<String, MSF4JBeanConfig>();
    private MicroservicesRegistry serviceRegistry;

    public SwaggerDefinitionService() {
    }

    public SwaggerDefinitionService(MicroservicesRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public void init(MicroservicesRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getSwaggerDefinition(@QueryParam(value="path") String path) throws Exception {
        MSF4JBeanConfig msf4JBeanConfig;
        if (path == null) {
            msf4JBeanConfig = this.swaggerBeans.get(GLOBAL);
            if (msf4JBeanConfig == null) {
                MSF4JBeanConfig beanConfig = new MSF4JBeanConfig(new ExtendedSwaggerReader("", new Swagger()));
                this.serviceRegistry.getHttpServices().stream().filter(service -> !service.getClass().equals(SwaggerDefinitionService.class)).forEach(service -> beanConfig.addServiceClass(service.getClass()));
                beanConfig.setScan(true);
                msf4JBeanConfig = beanConfig;
                this.swaggerBeans.put(GLOBAL, msf4JBeanConfig);
            }
        } else {
            Optional<Map.Entry<String, Object>> service2;
            msf4JBeanConfig = this.swaggerBeans.get(path);
            if (msf4JBeanConfig == null && (service2 = this.serviceRegistry.getServiceWithBasePath(path)).isPresent()) {
                MSF4JBeanConfig beanConfig = new MSF4JBeanConfig(new ExtendedSwaggerReader(path, new Swagger()));
                beanConfig.addServiceClass(service2.get().getValue().getClass());
                beanConfig.setBasePath(service2.get().getKey());
                beanConfig.setScan(true);
                msf4JBeanConfig = beanConfig;
                this.swaggerBeans.put(path, msf4JBeanConfig);
            }
        }
        return msf4JBeanConfig == null ? Response.status(Response.Status.NOT_FOUND).entity("{\"error\": \"Swagger definition not found for path " + path + "\"}").build() : Response.status(Response.Status.OK).entity(Json.mapper().writerWithDefaultPrettyPrinter().writeValueAsString(msf4JBeanConfig.getSwagger())).build();
    }
}

