/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.runtime;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.internal.runtime.CarbonRuntimeServiceMBean;
import org.wso2.carbon.kernel.internal.runtime.RuntimeManager;
import org.wso2.carbon.kernel.runtime.Runtime;
import org.wso2.carbon.kernel.runtime.RuntimeService;
import org.wso2.carbon.kernel.runtime.RuntimeState;
import org.wso2.carbon.kernel.runtime.exception.RuntimeServiceException;
import org.wso2.carbon.utils.Utils;

public class CarbonRuntimeService
implements RuntimeService,
CarbonRuntimeServiceMBean {
    private static Logger logger = LoggerFactory.getLogger(CarbonRuntimeService.class);
    RuntimeManager runtimeManager;

    public CarbonRuntimeService(RuntimeManager runtimeManager) {
        this.runtimeManager = runtimeManager;
    }

    @Override
    public void startRuntimes() throws RuntimeServiceException {
        Utils.checkSecurity();
        List<Runtime> runtimeMap = this.runtimeManager.getRuntimeList();
        for (Runtime runtime : runtimeMap) {
            if (runtime.getState() == RuntimeState.INACTIVE) {
                runtime.init();
                runtime.start();
                continue;
            }
            if (runtime.getState() == RuntimeState.PENDING) {
                throw new RuntimeServiceException("Runtime not initialized." + runtime.getClass().getName());
            }
            if (runtime.getState() == RuntimeState.MAINTENANCE) {
                throw new RuntimeServiceException("Runtime is in maintenance mode." + runtime.getClass().getName());
            }
            logger.error("Runtime already started : " + runtime.getClass().getName());
        }
    }

    @Override
    public void stopRuntimes() throws RuntimeServiceException {
        Utils.checkSecurity();
        List<Runtime> runtimeMap = this.runtimeManager.getRuntimeList();
        for (Runtime runtime : runtimeMap) {
            if (runtime.getState() == RuntimeState.PENDING) {
                throw new RuntimeServiceException("Runtime not initialized." + runtime.getClass().getName());
            }
            runtime.stop();
        }
    }

    @Override
    public void beginMaintenance() throws RuntimeServiceException {
        Utils.checkSecurity();
        List<Runtime> runtimeMap = this.runtimeManager.getRuntimeList();
        for (Runtime runtime : runtimeMap) {
            if (runtime.getState() == RuntimeState.PENDING) {
                throw new RuntimeServiceException("Runtime not initialized." + runtime.getClass().getName());
            }
            runtime.beginMaintenance();
        }
    }

    @Override
    public void endMaintenance() throws RuntimeServiceException {
        Utils.checkSecurity();
        List<Runtime> runtimeMap = this.runtimeManager.getRuntimeList();
        for (Runtime runtime : runtimeMap) {
            if (runtime.getState() == RuntimeState.PENDING) {
                throw new RuntimeServiceException("Runtime not initialized." + runtime.getClass().getName());
            }
            runtime.endMaintenance();
        }
    }
}

